/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Interface describing a find descriptor for children resources, narrowed by a
 * query expression and sorted by a collator.
 *
 * @created 23. Januar 2003
 */
public interface IAdvancedChildrenFindResourcesDescriptor
   extends IBasicChildrenFindResourcesDescriptor {
  /**
   * Get query expression to be used to narrow the list of returned resources.
   * </p> If certain properties used in the query expression do not exist at a
   * resource when evaluating the query expression, the evaluation should behave
   * gracefully. </p> The following defaults should be assumed: </p>
   * RESOURCENAME is the last RID part if not existent</br> COLLECTION is
   * assumed to be false, i.e. a simple resource if not existent</br> LINKTYPE
   * is assumed to be none, i.e. no link of any kind if not existent</br>
   * DISPLAYNAME is assumed to be the resource name if not existent</br>
   *
   * @return query expression
   * @see IQueryExpression
   */
  public IQueryExpression getQueryExpression();

  /**
   * Get collator to be used to sort the list of returned resources.
   *
   * @return collator
   * @see ICollator
   * @see ICollatorEntry
   */
  public ICollator getCollator();
}
