/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.common.*;

/**
 * Class implementing a destination of a resource in a namespace.
 *
 * @created 23. Januar 2003
 */
public class DestinationDescriptor implements IDestinationDescriptor {
  protected IRid parentCollectionRid;
  protected String childName;
  protected OrderPosition orderPosition;
  protected boolean overwriteEnforced;

  /**
   * Construct object of class DestinationDescriptor.
   *
   * @param parentCollectionRid parent collection resource id of the resource
   * @param childName name of the child resource
   * @param overwriteEnforced flag whether or not an existing resource should be
   *      overwritten
   */
  public DestinationDescriptor(IRid parentCollectionRid,
    String childName,
    boolean overwriteEnforced) {
    this.parentCollectionRid = parentCollectionRid;
    this.childName = childName;
    this.orderPosition = null;
    this.overwriteEnforced = overwriteEnforced;
  }

  /**
   * Construct object of class DestinationDescriptor.
   *
   * @param parentCollectionRid parent collection resource id of the resource
   * @param childName name of the child resource
   * @param orderPosition order position of the child resource
   * @param overwriteEnforced flag whether or not an existing resource should be
   *      overwritten
   */
  public DestinationDescriptor(IRid parentCollectionRid,
    String childName,
    OrderPosition orderPosition,
    boolean overwriteEnforced) {
    this.parentCollectionRid = parentCollectionRid;
    this.childName = childName;
    this.orderPosition = orderPosition;
    this.overwriteEnforced = overwriteEnforced;
  }

  /**
   * Get parent collection resource id of the resource.
   *
   * @return parent collection resource id of the resource
   */
  public IRid getParentCollectionRid() {
    return parentCollectionRid;
  }

  /**
   * Get name of the child resource.
   *
   * @return name of the child resource
   */
  public String getChildName() {
    return childName;
  }

  /**
   * Get order position of the child resource.
   *
   * @return order position of the child resource
   */
  public OrderPosition getOrderPosition() {
    return orderPosition;
  }

  /**
   * Get flag whether or not an existing resource should be overwritten.
   *
   * @return flag whether or not an existing resource should be overwritten
   */
  public boolean isOverwriteEnforced() {
    return overwriteEnforced;
  }
}
