/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.common.content.*;

import java.util.*;

/**
 * Class implementing content and properties of a resource.
 *
 * @created 23. Januar 2003
 */
public class ContentAndPropertiesDescriptor
   implements IContentAndPropertiesDescriptor {
  protected IMutableContent content;
  protected List properties;
  protected boolean propertyFailureToBeIgnored;

  /**
   * Construct object of class ContentAndPropertiesDescriptor.
   *
   * @param content content of the resource
   */
  public ContentAndPropertiesDescriptor(IMutableContent content) {
    this.content = content;
    this.properties = null;
    this.propertyFailureToBeIgnored = false;
  }

  /**
   * Construct object of class ContentAndPropertiesDescriptor.
   *
   * @param properties list of {@link IProperty} instances of the resource
   * @param propertyFailureToBeIgnored flag whether or not property failures
   *      should be ignored while managing the resource
   */
  public ContentAndPropertiesDescriptor(
    List properties,
    boolean propertyFailureToBeIgnored) {
    this.content = null;
    this.properties = properties;
    this.propertyFailureToBeIgnored = propertyFailureToBeIgnored;
  }

  /**
   * Construct object of class ContentAndPropertiesDescriptor.
   *
   * @param content content of the resource
   * @param properties list of {@link IProperty} instances of the resource
   * @param propertyFailureToBeIgnored flag whether or not property failures
   *      should be ignored while managing the resource
   */
  public ContentAndPropertiesDescriptor(
    IMutableContent content,
    List properties,
    boolean propertyFailureToBeIgnored) {
    this.content = content;
    this.properties = properties;
    this.propertyFailureToBeIgnored = propertyFailureToBeIgnored;
  }

  /**
   * Get content of the resource.
   *
   * @return content of the resource
   */
  public IMutableContent getContent() {
    return content;
  }

  /**
   * Get list of {@link IProperty} instances of the resource.
   *
   * @return list of {@link IProperty} instances of the resource
   */
  public List getProperties() {
    return properties;
  }

  /**
   * Get flag whether or not property failures should be ignored while managing
   * the resource.
   *
   * @return flag whether or not property failures should be ignored
   */
  public boolean isPropertyFailureToBeIgnored() {
    return propertyFailureToBeIgnored;
  }
}
