/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Class implementing a collection create descriptor used to create collections.
 *
 * @created 21. Februar 2003
 */
public class CollectionCreateDescriptor
   extends ResourceCreateDescriptor
   implements ICollectionCreateDescriptor {
  protected OrderMechanism orderMechanism;

  /**
   * Construct object of class CollectionCreateDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be created
   */
  public CollectionCreateDescriptor(IDestinationDescriptor destinationDescriptor) {
    super(destinationDescriptor);
    this.orderMechanism = null;
  }

  /**
   * Construct object of class CollectionCreateDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be created
   * @param orderMechanism order mechanism of the child collection
   */
  public CollectionCreateDescriptor(IDestinationDescriptor destinationDescriptor,
    OrderMechanism orderMechanism) {
    super(destinationDescriptor);
    this.orderMechanism = orderMechanism;
  }

  /**
   * Construct object of class CollectionCreateDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be created
   * @param contentAndPropertiesDescriptor resource content and properties of
   *      the resource to be created
   */
  public CollectionCreateDescriptor(IDestinationDescriptor destinationDescriptor,
    IContentAndPropertiesDescriptor contentAndPropertiesDescriptor) {
    super(destinationDescriptor, contentAndPropertiesDescriptor);
    this.orderMechanism = null;
  }

  /**
   * Construct object of class CollectionCreateDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be created
   * @param contentAndPropertiesDescriptor resource content and properties of
   *      the resource to be created
   * @param orderMechanism order mechanism of the child collection
   */
  public CollectionCreateDescriptor(IDestinationDescriptor destinationDescriptor,
    IContentAndPropertiesDescriptor contentAndPropertiesDescriptor,
    OrderMechanism orderMechanism) {
    super(destinationDescriptor, contentAndPropertiesDescriptor);
    this.orderMechanism = orderMechanism;
  }

  /**
   * Get order mechanism of the child collection.
   *
   * @return order mechanism of the child collection
   */
  public OrderMechanism getOrderMechanism() {
    return orderMechanism;
  }
}
