/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.util.namespace.*;

/**
 * Interface describing an entry in the collator list.
 *
 * @created 20. Mrz 2003
 * @see com.sap.netweaver.bc.rf.mi.namespace.INamespaceManager
 * @see ICollator
 */
public class CollatorEntry implements ICollatorEntry {
  private IName name;
  private boolean isAscending;

  /**
   * Construct object of class CollatorEntry.
   *
   * @param name name this collator entry is be based on
   * @param isAscending flag whether or not this collator entry should be used
   *      to sort in ascending or descending order
   */
  public CollatorEntry(IName name, boolean isAscending) {
    this.name = name;
    this.isAscending = isAscending;
  }

  /**
   * Get name this collator entry is be based on.
   *
   * @return name this collator entry is be based on
   */
  public IName getName() {
    return name;
  }

  /**
   * Get flag whether or not this collator entry should be used to sort in
   * ascending or descending order.
   *
   * @return flag whether or not this collator entry should be used to sort in
   *      ascending or descending order
   */
  public boolean isAscending() {
    return isAscending;
  }
}
