/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import java.util.*;

/**
 * Class implementing a collator and holding the list of ICollatorEntries.
 *
 * @created 20. Mrz 2003
 * @see com.sap.netweaver.bc.rf.mi.namespace.INamespaceManager
 * @see ICollatorEntry
 */
public class Collator extends ArrayList implements ICollator {
  /**
   * Constructs an empty collator list.
   */
  public Collator() {
    super();
  }

  /**
   * Constructs a collator list containing the elements of the specified
   * collection, in the order they are returned by the collection's iterator.
   * The <tt>Collator</tt> instance has an initial capacity of 110% the size of
   * the specified collection.
   *
   * @param collection collection whose elements are to be placed into this list
   */
  public Collator(Collection collection) {
    super(collection);
  }

  /**
   * Constructs an empty collator list with the specified initial capacity.
   *
   * @param initialCapacity the initial capacity of the list.
   */
  public Collator(int initialCapacity) {
    super(initialCapacity);
  }
}
