/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Class implementing a find descriptor for resources supporting find operations
 * for different depths. A depth of n always incldues the resources at the lower
 * n-1 levels, i.e. at a depth of 1, also the root resource is meant (in
 * contrast to find children operations); the behavior is only defined for the
 * values 0, 1 and MAX(INTEGER); the support of the depths 0 and 1 is mandatory;
 * for all other values a definition could be found, but the definiton would
 * exceed the functionality of many so far known repositories (DASL conform
 * repositories) and it's support might be difficult to inquire (in case of a
 * remote repository).
 *
 * @created 23. Januar 2003
 */
public class AdvancedDeepFindResourcesDescriptor
   extends AdvancedChildrenFindResourcesDescriptor
   implements IAdvancedDeepFindResourcesDescriptor {
  protected int depth;

  /**
   * Construct object of class FindAdvancedDeepResourcesDescriptor.
   *
   * @param queryExpression query expression
   * @param collator collator
   * @param depth depth
   */
  public AdvancedDeepFindResourcesDescriptor(
    IQueryExpression queryExpression,
    ICollator collator,
    int depth) {
    super(queryExpression, collator);
    this.depth = depth;
  }

  /**
   * Get depth to be used to find resources at the given depth and all levels
   * below this depth, i.e. at a depth of 1, also the root resource is meant (in
   * contrast to find children operations); the behavior is only defined for the
   * values 0, 1 and MAX(INTEGER); the support of the depths 0 and 1 is
   * mandatory; for all other values a definition could be found, but the
   * definiton would exceed the functionality of many so far known repositories
   * (DASL conform repositories) and it's support might be difficult to inquire
   * (in case of a remote repository).
   *
   * @return depth
   */
  public int getDepth() {
    return depth;
  }
}
