/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Class implementing a find descriptor for children resources, narrowed by a
 * filter and sorted by a collator.
 *
 * @created 23. Januar 2003
 */
public class AdvancedChildrenFindResourcesDescriptor
   extends BasicChildrenFindResourcesDescriptor
   implements IAdvancedChildrenFindResourcesDescriptor {
  protected IQueryExpression queryExpression;
  protected ICollator collator;

  /**
   * Construct object of class FindAdvancedChildrenResourcesDescriptor.
   *
   * @param queryExpression query expression
   * @param collator collator
   */
  public AdvancedChildrenFindResourcesDescriptor(
    IQueryExpression queryExpression,
    ICollator collator) {
    super();
    this.queryExpression = queryExpression;
    this.collator = collator;
  }

  /**
   * Get query expression to be used to narrow the list of returned resources.
   *
   * @return query expression
   * @see IQueryExpression
   */
  public IQueryExpression getQueryExpression() {
    return queryExpression;
  }

  /**
   * Get collator to be used to sort the list of returned resources.
   *
   * @return collator
   * @see ICollator
   * @see ICollatorEntry
   */
  public ICollator getCollator() {
    return collator;
  }
}
