/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.lock;

/**
 * Enumeration of supported options of resources and repositories. <p>
 *
 * Note that the availability of the generally supported options may depend on
 * the resource for which the option was requested, while others apply to the
 * whole repository in general. <p>
 *
 * The supported options may be used by a UI to signal which kind of operations
 * are allowed on a resource or repository. Internally they are used to quickly
 * discover the features of a repository and use only the supported features and
 * bypass the others resp. quickly fail in a requested operation.
 *
 * @author m.breitenfelder@sapportals.com
 * @author julian.reschke@greenbytes.de
 * @created 29. Januar 2003
 */
public final class SupportedOption extends com.sap.netweaver.bc.rf.common.support.SupportedOption {
  /**
   * Resource manager supports locking operations in general
   */
  public final static SupportedOption LOCK =
    new SupportedOption(1, "Lock");

  /**
   * Resource manager supports deep locks
   */
  public final static SupportedOption LOCK_DEEP =
    new SupportedOption(2, "Lock Deep");

  /**
   * Resource manager supports shallow locks
   */
  public final static SupportedOption LOCK_SHALLOW =
    new SupportedOption(3, "Lock Shallow");

  /**
   * Resource manager supports shared locks
   */
  public final static SupportedOption LOCK_SHARED =
    new SupportedOption(4, "Lock Shared");

  /**
   * Resource manager supports exclusive locks
   */
  public final static SupportedOption LOCK_EXCLUSIVE =
    new SupportedOption(5, "Lock Exclusive");

  /**
   * Resource manager supports read locks
   */
  public final static SupportedOption LOCK_READ =
    new SupportedOption(6, "Lock Read");

  /**
   * Resource manager supports write locks
   */
  public final static SupportedOption LOCK_WRITE =
    new SupportedOption(7, "Lock Write");

  /**
   * Construct object of class SupportedOption.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private SupportedOption(int id, String description) {
    super(id, description);
  }
}
