/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.lock;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Definiton of different lock scopes, i.e. whether this is a shared or an
 * exclusive lock. Exclusive locks block any other lock from being obtained on
 * the given resource handle and block any unlocked access. Shared locks block
 * any exclusive lock from being obtained on the given resource handle and block
 * any unlocked access too, but allow for further shared locks.
 *
 * @created 27. Januar 2003
 */
public final class LockScopeType extends EnumWithDescription {
  public final static LockScopeType SHARED = new LockScopeType(1, "Shared");
  public final static LockScopeType EXCLUSIVE = new LockScopeType(2, "Exclusive");

  /**
   * Construct object of class LockScopeType.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private LockScopeType(final int id, final String description) {
    super(id, description, false);
  }
}
