/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.lock;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Definiton of different lock kinds, i.e. whether this is a read or a write
 * lock. Write locks define access for write operations. Read locks define
 * access for read operations, but are currently not used within the framework.
 *
 * @created 27. Januar 2003
 */
public final class LockKindType extends EnumWithDescription {
  public final static LockKindType READ = new LockKindType(1, "Read");
  public final static LockKindType WRITE = new LockKindType(2, "Write");

  /**
   * Construct object of class LockKindType.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private LockKindType(final int id, final String description) {
    super(id, description, false);
  }
}
