/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.lock;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Definiton of different lock depths, i.e. whether this is a shallow or a deep
 * lock. Shallow locks affect only the given resource handle, where deep locks
 * effect also the descendents in the resource hierarchy.
 *
 * @created 29. Januar 2003
 */
public final class LockDepthType extends EnumWithDescription {
  public final static LockDepthType SHALLOW = new LockDepthType(1, "Shallow");
  public final static LockDepthType DEEP = new LockDepthType(2, "Deep");

  /**
   * Construct object of class LockDepthType.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private LockDepthType(final int id, final String description) {
    super(id, description, false);
  }
}
