/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.lock;

/**
 * Interface describing a lock descriptor.
 *
 * @created 20. Mrz 2003
 */
public interface ILockDescriptor {
  /**
   * Get lock depth.
   *
   * @return {@link LockDepthType} of lock
   */
  public LockDepthType getDepth();

  /**
   * Get lock scope.
   *
   * @return {@link LockScopeType} of lock
   */
  public LockScopeType getScope();

  /**
   * Get lock kind.
   *
   * @return {@link LockKindType} of lock
   */
  public LockKindType getKind();

  /**
   * Get lock timeout in milliseconds.
   *
   * @return lock timeout in milliseconds
   */
  public long getTimeout();

  /**
   * Get client supplied owner for the lock. A client can submit his own owner
   * information that should be returned upon lock discovery. If present, the
   * format must be the XML serialization of a <a
   * href="http://www.greenbytes.de/tech/webdav/rfc2518.html#ELEMENT_owner">
   * DAV:owner</a> element.
   *
   * @return client supplied owner for the lock
   */
  public String getClientSuppliedOwner();

  /**
   * Set lock depth.
   *
   * @param depth {@link LockDepthType} of lock
   */
  public void setDepth(LockDepthType depth);

  /**
   * Set lock scope.
   *
   * @param scope {@link LockScopeType} of lock
   */
  public void setScope(LockScopeType scope);

  /**
   * Set lock type.
   *
   * @param kind The new kind value
   */
  public void setKind(LockKindType kind);

  /**
   * Set lock timeout in milliseconds.
   *
   * @param timeout lock timeout in milliseconds
   */
  public void setTimeout(long timeout);

  /**
   * Set client supplied owner for the lock. A client can submit his own owner
   * information that should be returned upon lock discovery. If present, the
   * format must be the XML serialization of a <a
   * href="http://www.greenbytes.de/tech/webdav/rfc2518.html#ELEMENT_owner">
   * DAV:owner</a> element.
   *
   * @param clientSuppliedOwner client supplied owner for the lock
   */
  public void setClientSuppliedOwner(String clientSuppliedOwner);
}
