/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.exception;

import com.sap.netweaver.bc.rf.util.exception.*;

/**
 * Class implementing an exception used in conjunction with resource processing.
 *
 * @author m.breitenfelder@sapportals.com
 * @created 23. Januar 2003
 */
public class RepositoryException extends BaseException {
  // Definition of default auto exception log behaviour,
  // used when no user behaviour is supplied during exception construction
  private final static boolean LOG_EXCEPTION_ON_CREATION = true;

  /**
   * Construct object of class RepositoryException.
   */
  public RepositoryException() {
    super(LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public RepositoryException(boolean logExceptionOnCreation) {
    super(logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param rootCause throwable object which caused this exception
   */
  public RepositoryException(Throwable rootCause) {
    super(rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public RepositoryException(Throwable rootCause, boolean logExceptionOnCreation) {
    super(rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   */
  public RepositoryException(String message) {
    super(message, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   */
  public RepositoryException(String message, Object[] args) {
    super(message, args, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   */
  public RepositoryException(String message, Throwable rootCause) {
    super(message, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   */
  public RepositoryException(String message, Object[] args, Throwable rootCause) {
    super(message, args, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public RepositoryException(String message, boolean logExceptionOnCreation) {
    super(message, logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public RepositoryException(
    String message,
    Object[] args,
    boolean logExceptionOnCreation) {
    super(message, args, logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public RepositoryException(
    String message,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(message, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public RepositoryException(
    String message,
    Object[] args,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(message, args, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   */
  protected RepositoryException(ResourceAccessor resourceAccessor, String key) {
    super(resourceAccessor, key, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   */
  protected RepositoryException(
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args) {
    super(resourceAccessor, key, args, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param rootCause throwable object which caused this exception
   */
  protected RepositoryException(
    ResourceAccessor resourceAccessor,
    String key,
    Throwable rootCause) {
    super(resourceAccessor, key, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   */
  protected RepositoryException(
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    Throwable rootCause) {
    super(resourceAccessor, key, args, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected RepositoryException(
    ResourceAccessor resourceAccessor,
    String key,
    boolean logExceptionOnCreation) {
    super(resourceAccessor, key, logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected RepositoryException(
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    boolean logExceptionOnCreation) {
    super(resourceAccessor, key, args, logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected RepositoryException(
    ResourceAccessor resourceAccessor,
    String key,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(resourceAccessor, key, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected RepositoryException(
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(resourceAccessor, key, args, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   */
  protected RepositoryException(ResourceMessage message) {
    super(message, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   */
  protected RepositoryException(ResourceMessage message, Throwable rootCause) {
    super(message, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected RepositoryException(ResourceMessage message, boolean logExceptionOnCreation) {
    super(message, logExceptionOnCreation);
  }

  /**
   * Construct object of class RepositoryException.
   *
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected RepositoryException(
    ResourceMessage message,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(message, rootCause, logExceptionOnCreation);
  }
}
