/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.exception;

import com.sap.netweaver.bc.rf.util.exception.*;

import java.util.*;

/**
 * Class implementing an exception used in all non-atomic operations when parts
 * of an operation failed. This exception class helps to return the partially
 * computed results and a list of throwables for all failed parts.
 *
 * @created 7. Mrz 2003
 */
public class OperationNotCompletedException extends RepositoryException {
  // Partially computed result
  private Object partiallyComputedResult;

  // List of throwables describing the failed operations
  private List throwables;

  // Definition of default auto exception log behaviour,
  // used when no user behaviour is supplied during exception construction
  private final static boolean LOG_EXCEPTION_ON_CREATION = true;

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables) {
    super(LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables, boolean logExceptionOnCreation) {
    super(logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param rootCause throwable object which caused this exception
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables, Throwable rootCause) {
    super(rootCause, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables, Throwable rootCause, boolean logExceptionOnCreation) {
    super(rootCause, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables, String message) {
    super(message, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables, String message, Object[] args) {
    super(message, args, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables, String message, Throwable rootCause) {
    super(message, rootCause, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables, String message, Object[] args, Throwable rootCause) {
    super(message, args, rootCause, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables, String message, boolean logExceptionOnCreation) {
    super(message, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    String message,
    Object[] args,
    boolean logExceptionOnCreation) {
    super(message, args, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    String message,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(message, rootCause, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    String message,
    Object[] args,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(message, args, rootCause, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables, ResourceAccessor resourceAccessor, String key) {
    super(resourceAccessor, key, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args) {
    super(resourceAccessor, key, args, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param rootCause throwable object which caused this exception
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    ResourceAccessor resourceAccessor,
    String key,
    Throwable rootCause) {
    super(resourceAccessor, key, rootCause, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    Throwable rootCause) {
    super(resourceAccessor, key, args, rootCause, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    ResourceAccessor resourceAccessor,
    String key,
    boolean logExceptionOnCreation) {
    super(resourceAccessor, key, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    boolean logExceptionOnCreation) {
    super(resourceAccessor, key, args, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    ResourceAccessor resourceAccessor,
    String key,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(resourceAccessor, key, rootCause, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(resourceAccessor, key, args, rootCause, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables, ResourceMessage message) {
    super(message, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables, ResourceMessage message, Throwable rootCause) {
    super(message, rootCause, LOG_EXCEPTION_ON_CREATION);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables, ResourceMessage message, boolean logExceptionOnCreation) {
    super(message, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Construct object of class OperationNotCompletedException.
   *
   * @param partiallyComputedResult partially computed result
   * @param throwables list of throwables for all failed parts
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected OperationNotCompletedException(Object partiallyComputedResult, List throwables,
    ResourceMessage message,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(message, rootCause, logExceptionOnCreation);
    this.partiallyComputedResult = partiallyComputedResult;
    this.throwables = throwables;
  }

  /**
   * Get partially computed result.
   *
   * @return partially computed result
   */
  public Object getPartiallyComputedResult() {
    return partiallyComputedResult;
  }

  /**
   * Get list of throwables for all failed parts.
   *
   * @return list of throwables for all failed parts
   */
  public List getThrowables() {
    return throwables;
  }
}
