/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.context;

import com.sap.netweaver.bc.rf.common.exception.*;

import com.sap.security.api.*;

import java.util.*;

/**
 * Interface describing the access context information the system needs to know,
 * when working on resources.
 *
 * @created 23. Januar 2003
 */
public interface IAccessContext {
  /**
   * Get id of the current client operating on the resouce.
   *
   * @return id of the current client operating on the resouce
   */
  public String getClientId();

  /**
   * Set id of the current client operating on the resouce.
   *
   * @param clientId id of the current client operating on the resouce
   */
  public void setClientId(String clientId);

  /**
   * Get current user operating on the resouce.
   *
   * @return current user operating on the resouce
   */
  public IUser getUser();

  /**
   * Set current user operating on the resouce.
   *
   * @param user current user operating on the resouce
   */
  public void setUser(IUser user);

  /**
   * Get locale of the current user.
   *
   * @return locale of the current user
   */
  public Locale getLocale();

  /**
   * Set locale of the current user.
   *
   * @param locale locale of the current user
   */
  public void setLocale(Locale locale);

  /**
   * Get time the repository data may not be older than.
   *
   * @return time the repository data may not be older than
   */
  public long getAllowedStaleDataTimespan();

  /**
   * Set time the repository data may not be older than.
   *
   * @param allowedStaleDataTimespan The new allowedStaleDataTimespan value
   */
  public void setAllowedStaleDataTimespan(long allowedStaleDataTimespan);

  /**
   * Get a client defined property from the context.
   *
   * @param name name of the client defined property
   * @return value of the client defined property
   */
  public Object getClientDefinedProperty(String name);

  /**
   * Set a client defined property in the context.
   *
   * @param name name of the client defined property
   * @param value value of the client defined property
   * @exception RepositoryException Exception raised in failure situation
   */
  public void setClientDefinedProperty(String name, Object value)
    throws RepositoryException;

  /**
   * Clone access context.
   *
   * @return cloned access context
   */
  public IAccessContext cloneContext();
}
