/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.content;

import com.sap.netweaver.bc.rf.common.exception.ResourceException;

import java.io.InputStream;

/**
 * Access to the content data of a resource. <p>
 *
 *
 *
 * @author m.breitenfelder@sapportals.com
 * @author julian.reschke@greenbytes.de
 * @created 14. April 2003
 */

public class MutableContent extends Content implements IMutableContent {
  private boolean contentMetadataUpdatedState = false;

  /**
   * Constructs Content object, for use when media subtype and encoding are
   * available as individual values.
   *
   * @param inputStream input stream
   * @param contentMetadata content metadata
   */
  public MutableContent(InputStream inputStream, IContentMetadata contentMetadata) {
    super(inputStream, contentMetadata);
  }

  /**
   * Constructs Content object, for use when media subtype and encoding are
   * available as individual values.
   *
   * @param inputStream input stream
   * @param mediaType media type of content (trailing parameters are ignored)
   * @param contentLength length of content (use -1 when unknown)
   * @param encoding character encoding (use <code>null</code> when unknown)
   * @param language content language (use <code>null</code> when unknown)
   */
  public MutableContent(InputStream inputStream, String mediaType, long contentLength, String encoding, String language) {
    super(inputStream, mediaType, contentLength, encoding, language);
  }

  /**
   * Constructs Content object, for use when encoding is not known separately
   * but may be present in media type string.
   *
   * @param inputStream input stream
   * @param mediaType media type of content (trailing parameters except encoding
   *      information is ignored)
   * @param contentLength length of content (use -1 when unknown)
   */
  public MutableContent(InputStream inputStream, String mediaType, long contentLength) {
    super(inputStream, mediaType, contentLength);
  }

  /**
   * Set the metadata attribute of the MutableContent object.
   *
   * @param newContentMetadata contentMetadata to be set
   * @exception ResourceException Exception raised in failure situation
   */
  public void setContentMetadata(IContentMetadata newContentMetadata)
    throws ResourceException {
    this.contentMetadataUpdatedState = true;
    this.contentMetadata = newContentMetadata;
  }

  /**
   * Check whether or not the metadata was updated since the creation of this
   * mutable content or the last reset of the metadata updated state.
   *
   * @return flag whether or not the metadata was updated
   */
  public boolean getContentMetadataUpdatedState() {
    return this.contentMetadataUpdatedState;
  }

  /**
   * Reset the metadata updated state to false.
   */
  public void resetContentMetadataUpdatedState() {
    this.contentMetadataUpdatedState = false;
  }
}
