/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.content;

import com.sap.netweaver.bc.rf.common.exception.*;

/**
 * Interface for updating the content metadata, which will change when the
 * content is actually persisted by the repository manager.
 *
 * @author manfred.baedke@greenbytes.de
 * @created 20. Mrz 2003
 */
public interface IMutableContent extends IContent {
  /**
   * Set the content metadata.
   *
   * @param contentMetadata contentMetadata to be set
   * @exception ResourceException when the operation failed
   */
  public void setContentMetadata(IContentMetadata contentMetadata)
    throws ResourceException;

  /**
   * Check whether or not the metadata was updated since the creation of this
   * mutable content or the last reset of the metadata updated state.
   *
   * @return flag whether or not the content metadata was updated
   */
  public boolean getContentMetadataUpdatedState();

  /**
   * Reset the content metadata updated state to false.
   */
  public void resetContentMetadataUpdatedState();
}
