/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.content;

import java.util.Date;

/**
 * Interface describing the content metadata of the content a resource may
 * provide. <p>
 *
 *
 *
 * @author m.breitenfelder@sap.com
 * @author julian.reschke@greenbytes.de
 * @author manfred.baedke@greenbytes.de
 * @created 11. Mrz 2003
 */
public interface IContentMetadata {
  /**
   * Returns the length of resource content in bytes or -1 if not known.
   *
   * @return length of resource content in bytes
   */
  public long getContentLength();

  /**
   * Returns the content type of resource content as media sub type or null if
   * not known.
   *
   * @return content type of resource content as media sub type (may be null)
   */
  public String getContentType();

  /**
   * Returns the content encoding of resource content or null if not known.
   *
   * @return content encoding of resource content (may be null)
   */
  public String getContentEncoding();

  /**
   * Returns the content language (see <a
   * href="http://www.ietf.org/rfc/rfc2616">RFC2616</a> , section 14.12) or
   * <code>null</code> when not known.
   *
   * @return content language (may be null)
   */
  public String getContentLanguage();

  /**
   * Returns the entity-tag for the content (see <a
   * href="http://www.ietf.org/rfc/rfc2616">RFC2616</a> , section 14.19). Note
   * that the entity tag may be a <em>weak</em> entity tag (indicated by a
   * leading "W/"). Only strong entity tags can be used to assert octet-by-octet
   * entity body identity, though.
   *
   * @return entity-tag of the content (may be null)
   */
  public String getETag();

  /**
   * Returns the expires date of the content (see <a
   * href="http://www.ietf.org/rfc/rfc2616">RFC2616</a> , section 14.21) or
   * <code>null</code> when not specified.
   *
   * @return expires date of the content (may be null)
   */
  public Date getExpires();

  /**
   * Returns the last modification date of the content (see <a
   * href="http://www.ietf.org/rfc/rfc2616">RFC2616</a> , section 14.29) or
   * <code>null</code> when not known.
   *
   * @return last modification date of the content (may be null)
   */
  public Date getLastModified();
}
