/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.content;

import com.sap.netweaver.bc.rf.common.exception.*;

import java.io.InputStream;

/**
 * Interface describing content a resource may provide. <p>
 *
 * This class provides access both to the actual content and the meta data
 * related to it. This set of information MUST be consistent. <p>
 *
 * The following usage patterns need to be considered: <p>
 *
 * <em>Accessing just the meta data:</em> This is the typical call pattern when
 * the client only needs the meta data, but won't actually read the content (for
 * instance when displaying information about the members of a collection). In
 * this case, getInputStream() will <em>not</em> be called. Note that
 * implementations should avoid to internally open an input stream if the caller
 * doesn't access it. <p>
 *
 * <em>Accessing both content and meta data:</em> This requires that the meta
 * data returned accurately reflects the input stream that is returned and is
 * the typical use case for an HTTP GET operation on the content (content length
 * when known MUST be accurate). In this scenario, a client SHOULD call
 * getInputStream() first, this allows the implementation to get a consistent
 * set of meta data related to the input stream. If the client does not follow
 * this recommended calling sequence, an implementation may have to signal a
 * ContentException when it detects that meta data returned earlier does not
 * match the actual data of the input stream opened. If the resource was deleted
 * after the content object was created, the implementation SHOULD report a
 * ResourceNotFoundException when trying to retrieve the input stream. <p>
 *
 *
 *
 * @author m.breitenfelder@sap.com
 * @author julian.reschke@greenbytes.de
 * @author manfred.baedke@greenbytes.de
 * @created 20. Mrz 2003
 */
public interface IContent {
  /**
   * Get input stream for the resource content.
   *
   * @return input stream for the resource content
   * @exception ResourceException when the operation failed
   */
  public InputStream getInputStream()
    throws ResourceException;


  /**
   * Get the content metadata.
   *
   * @return content metadata
   * @exception ResourceException when the operation failed
   */
  public IContentMetadata getContentMetadata()
    throws ResourceException;
}
