/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.content;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Enumeration of content metadata tpyes.
 *
 * @author Vedran Lerenc
 * @created 29. Januar 2003
 */
public final class ContentMetadataType extends EnumWithDescription {
  public final static ContentMetadataType NONE = new ContentMetadataType(1, "None");
  public final static ContentMetadataType CONTENTLENGTH = new ContentMetadataType(2, "ContentLength");
  public final static ContentMetadataType CONTENTTYPE = new ContentMetadataType(3, "ContentType");
  public final static ContentMetadataType CONTENTENCODING = new ContentMetadataType(4, "ContentEncoding");
  public final static ContentMetadataType CONTENTLANGUAGE = new ContentMetadataType(5, "ContentLanguage");
  public final static ContentMetadataType ETAG = new ContentMetadataType(6, "ETag");
  public final static ContentMetadataType EXPIRES = new ContentMetadataType(7, "Expires");
  public final static ContentMetadataType LASTMODIFIED = new ContentMetadataType(8, "LastModified");

  /**
   * Construct object of class ContentMetadataType.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private ContentMetadataType(final int id, final String description) {
    super(id, description, false);
  }
}
