/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.content;

import java.util.Date;

/**
 * Interface describing the content metadata of the content a resource may
 * provide. <p>
 *
 *
 *
 * @author martin.boettcher@greenbytes.de
 * @created 14. April 2003
 */
public class ContentMetadata implements IContentMetadata {
  private long contentLength;
  private String contentType, contentEncoding, contentLanguage, eTag;
  private Date expires, lastModified;

  /**
   * Construct object of class ContentMetadata.
   *
   * @param orgContentMetadata original content metadata
   * @param eTag entity tag
   */
  public ContentMetadata(IContentMetadata orgContentMetadata, String eTag) {
    this.contentLength = orgContentMetadata.getContentLength();
    this.contentType = orgContentMetadata.getContentType();
    this.contentEncoding = orgContentMetadata.getContentEncoding();
    this.contentLanguage = orgContentMetadata.getContentLanguage();
    this.eTag = eTag;
    this.expires = orgContentMetadata.getExpires();
    this.lastModified = orgContentMetadata.getLastModified();
  }

  /**
   * Construct object of class ContentMetadata.
   *
   * @param orgContentMetadata original content metadata
   * @param contentLength content length
   */
  public ContentMetadata(IContentMetadata orgContentMetadata, long contentLength) {
    this.contentLength = contentLength;
    this.contentType = orgContentMetadata.getContentType();
    this.contentEncoding = orgContentMetadata.getContentEncoding();
    this.contentLanguage = orgContentMetadata.getContentLanguage();
    this.eTag = orgContentMetadata.getETag();
    this.expires = orgContentMetadata.getExpires();
    this.lastModified = orgContentMetadata.getLastModified();
  }

  /**
   * Construct object of class ContentMetadata.
   *
   * @param orgContentMetadata original content metadata
   * @param eTag entity tag
   * @param lastModified last modified date
   */
  public ContentMetadata(IContentMetadata orgContentMetadata, String eTag, Date lastModified) {
    this.contentLength = orgContentMetadata.getContentLength();
    this.contentType = orgContentMetadata.getContentType();
    this.contentEncoding = orgContentMetadata.getContentEncoding();
    this.contentLanguage = orgContentMetadata.getContentLanguage();
    this.eTag = eTag;
    this.expires = orgContentMetadata.getExpires();
    this.lastModified = lastModified;
  }

  /**
   * Construct object of class ContentMetadata.
   *
   * @param orgContentMetadata original content metadata
   * @param contentLength content length
   * @param eTag entity tag
   * @param lastModified last modified date
   */
  public ContentMetadata(
    IContentMetadata orgContentMetadata,
    long contentLength,
    String eTag,
    Date lastModified) {
    this.contentLength = contentLength;
    this.contentType = orgContentMetadata.getContentType();
    this.contentEncoding = orgContentMetadata.getContentEncoding();
    this.contentLanguage = orgContentMetadata.getContentLanguage();
    this.eTag = eTag;
    this.expires = orgContentMetadata.getExpires();
    this.lastModified = lastModified;
  }

  /**
   * Construct object of class ContentMetadata.
   *
   * @param contentLength content length
   * @param contentType content type
   * @param contentEncoding content encoding
   * @param contentLanguage content language
   * @param eTag entity tag
   * @param expires expires date
   * @param lastModified last modified date
   */
  public ContentMetadata(
    long contentLength,
    String contentType,
    String contentEncoding,
    String contentLanguage,
    String eTag,
    Date expires,
    Date lastModified) {
    this.contentLength = contentLength;
    this.contentType = contentType;
    this.contentEncoding = contentEncoding;
    this.contentLanguage = contentLanguage;
    this.eTag = eTag;
    this.expires = expires;
    this.lastModified = lastModified;
  }

  /**
   * Get the contentLength attribute of the ContentMetadata object.
   *
   * @return contentLength value
   */
  public long getContentLength() {
    return this.contentLength;
  }

  /**
   * Get the contentType attribute of the ContentMetadata object.
   *
   * @return contentType value
   */
  public String getContentType() {
    return this.contentType;
  }

  /**
   * Get the encoding attribute of the ContentMetadata object.
   *
   * @return encoding value
   */
  public String getContentEncoding() {
    return this.contentEncoding;
  }

  /**
   * Get the language attribute of the ContentMetadata object.
   *
   * @return language value
   */
  public String getContentLanguage() {
    return this.contentLanguage;
  }

  /**
   * Get the entityTag attribute of the ContentMetadata object.
   *
   * @return entityTag value
   */
  public String getETag() {
    return this.eTag;
  }

  /**
   * Get the expires attribute of the ContentMetadata object.
   *
   * @return expires value
   */
  public Date getExpires() {
    return this.expires;
  }

  /**
   * Get the lastModified attribute of the ContentMetadata object.
   *
   * @return lastModified value
   */
  public Date getLastModified() {
    return this.lastModified;
  }
}
