/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.binding;

/**
 * Class implementing copy flags for a resource to be copied. Note: Please do
 * not activate this package as-is, but try to reintegrate it into the namespace
 * package. There are many similar but just temporarily moved and overwritten
 * methods in the rmi namespace package also.
 *
 * @created 23. Januar 2003
 */
public class CopyFlagsDescriptor extends com.sap.netweaver.bc.rf.common.namespace.CopyFlagsDescriptor implements ICopyFlagsDescriptor {
  protected boolean childrenBindingToBeCopied;

  /**
   * Construct object of class CopyFlagsDescriptor.
   *
   * @param childrenToBeCopied flag whether or not children should be copied
   * @param childrenLinkTypesToBeCopied flag whether or not child links of the
   *      given {@link LinkType} should be copied
   * @param childrenBindingToBeCopied flag whether or not child bindings should
   *      be copied
   */
  public CopyFlagsDescriptor(
    boolean childrenToBeCopied,
    com.sap.netweaver.bc.rf.common.namespace.LinkType[] childrenLinkTypesToBeCopied,
    boolean childrenBindingToBeCopied) {
    super(childrenToBeCopied, childrenLinkTypesToBeCopied);
    this.childrenBindingToBeCopied = childrenBindingToBeCopied;
  }

  /**
   * Get flag whether or not child bindings should be copied.
   *
   * @return flag whether or not child bindings should be copied
   */
  public boolean isChildrenBindingToBeCopied() {
    return childrenBindingToBeCopied;
  }
}
