/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.binding;

/**
 * Class implementing a copy descriptor used to copy resources. Note: Please do
 * not activate this package as-is, but try to reintegrate it into the namespace
 * package. There are many similar but just temporarily moved and overwritten
 * methods in the rmi namespace package also.
 *
 * @created 23. Januar 2003
 */
public class CopyDescriptor extends MoveDescriptor implements ICopyDescriptor {
  protected ICopyFlagsDescriptor copyFlagsDescriptor;

  /**
   * Construct object of class CopyDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be operated
   * @param copyFlagsDescriptor copy flags which should be used
   */
  public CopyDescriptor(
    com.sap.netweaver.bc.rf.common.namespace.IDestinationDescriptor destinationDescriptor,
    ICopyFlagsDescriptor copyFlagsDescriptor) {
    super(destinationDescriptor);
    this.copyFlagsDescriptor = copyFlagsDescriptor;
  }

  /**
   * Construct object of class CopyDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be operated
   * @param propertyFailureToBeIgnored flag whether or not property failures
   *      should be ignored while managing the resource
   * @param copyFlagsDescriptor copy flags which should be used
   */
  public CopyDescriptor(
    com.sap.netweaver.bc.rf.common.namespace.IDestinationDescriptor destinationDescriptor,
    boolean propertyFailureToBeIgnored,
    ICopyFlagsDescriptor copyFlagsDescriptor) {
    super(destinationDescriptor, propertyFailureToBeIgnored);
    this.copyFlagsDescriptor = copyFlagsDescriptor;
  }

  /**
   * Get copy flags which should be used.
   *
   * @return copy flags which should be used
   */
  public ICopyFlagsDescriptor getCopyFlagsDescriptor() {
    return copyFlagsDescriptor;
  }
}
