/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common;

/**
 * A <a href="http://greenbytes.de/tech/webdav/rfc2518.html#rfc.section.6.4">
 * RFC2518</a> IUri implementation. <pre>
 *      lturl      := "opaquelocktoken:" UUID [ext]
 *      ext        := path
 * </pre> <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: OpaqueLockTokenUri.java,v 1.2 2003/04/28 10:08:34 jre Exp $
 */

public class OpaqueLockTokenUri implements IAbsoluteUri {

  private final static String SCHEME = "opaquelocktoken";
  private final String remainder;
  private int hashCode;

  public OpaqueLockTokenUri(String remainder)
    throws IllegalArgumentException {
    this.remainder = remainder;
  }

  protected IAbsoluteUri newInstance(String remainder)
    throws IllegalArgumentException {
    return new OpaqueLockTokenUri(remainder);
  }

  public String getRemainder() {
    return remainder;
  }

  public String getScheme() {
    return SCHEME;
  }

  public int hashCode() {
    if (this.hashCode == 0) {
      this.hashCode = this.toString().hashCode();
    }
    return this.hashCode;
  }

  public String toExternalForm() {
    return SCHEME + ":" + remainder;
  }

  public String toString() {
    return toExternalForm();
  }

  public IAbsoluteUri resolve(IUriReference ref)
    throws IllegalArgumentException {
    throw new IllegalArgumentException("resolution not supported for opaquelocktoken scheme");
  }

  public boolean equals(Object other) {
    if (other instanceof IAbsoluteUri) {
      return this.equals((IAbsoluteUri)other);
    }
    return false;
  }

  public boolean equals(IAbsoluteUri other) {
    if (other == null) {
      return false;
    }
    if (other == this) {
      return true;
    }
    return SCHEME.equalsIgnoreCase(other.getScheme())
       && this.remainder.equals(other.getRemainder());
  }
}
