/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common;

/**
 * Interface describing a resource handle. Each resource going in and out a
 * repository (sub) manager must implement this interface and may be enriched by
 * further information by the creating repository. This information is carried
 * by the resource along and should be used within the repository, e.g. to hide
 * some fast lookup/access information and the like.
 *
 * @created 23. Januar 2003
 */
public interface IResourceHandle {
  /**
   * Get the resource identifier of the resource handle.
   *
   * @return resource identifier
   */
  public IRid getRid();
}
