/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common;

/**
 * A <a href="http://www.ietf.org/rfc/rfc2396.txt">RFC2396</a> absolute URI
 * interface. <pre>
 *     Uri ::= scheme ':' remainder
 * </pre> <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author julian.reschke@greenbytes.de
 * @author stefan.eissing@greenbytes.de
 * @created 20. Mrz 2003
 * @version $Id: IAbsoluteUri.java,v 1.1 2003/04/28 10:08:34 jre Exp $
 */

public interface IAbsoluteUri {

  /**
   * Get the scheme of this AbsoluteUri (without ':').
   *
   * @return scheme of this AbsoluteUri
   */
  public String getScheme();

  /**
   * Get the remainder of this AbsoluteUri (part after scheme without ':').
   *
   * @return remainder of this AbsoluteUri
   */
  public String getRemainder();

  /**
   * Resolve the URI reference in the context of this AbsoluteUri (as per
   * RFC2396, section 5.2).
   *
   * @param reference URI reference to be resolved
   * @return resolved reference as absolute URI without fragment identifier
   * @exception IllegalArgumentException Exception raised in failure situation
   */
  public IAbsoluteUri resolve(IUriReference reference)
    throws IllegalArgumentException;

  /**
   * Returns a string representation according to RFC 2396 of this uri.
   *
   * @return string in URI format
   */
  public String toExternalForm();
}
