/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common;

/**
 * Class implementing a resource handle.
 *
 * @created 21. Februar 2003
 * @see IResourceHandle
 */
public abstract class AbstractResourceHandle implements IResourceHandle {
  private final IRid rid;

  /**
   * Construct resource handle.
   *
   * @param rid resource identifier
   */
  public AbstractResourceHandle(IRid rid) {
    this.rid = rid;
  }

  /**
   * Get the resource identifier of the resource handle.
   *
   * @return resource identifier
   */
  public IRid getRid() {
    return this.rid;
  }
}
