/*
 * Created on Jun 24, 2003
 */
package com.sap.caf.rt.ui.cool.utils;


/**
 *	This class represents exceptions that may arise
 *	on using the {@link CoolConnectionProperties} class.
 *
 * @author Victor Kulaga
 * @version 1.0
 */
public class CoolConnectionPropertiesException extends Exception {

	/**
	 * Default constructor of this exception class.
	 */
	public CoolConnectionPropertiesException() {
		super();
	}

	/**
	 * Use this constructor to specify the explanation or reason of risen exception.
	 * @param s The string specified as exception explanation or reason.
	 */
	public CoolConnectionPropertiesException(String s) {
		super(s);
	}
	
	/**
	 * Use this constructor to specify the explanation or reason of risen exception.
	 * @param cause is used when this exception is caused by another exception ({@link Throwable} object specified)
	 * @param s The string specified as exception explanation or reason.
	 */
	public CoolConnectionPropertiesException(String s, Throwable cause) {
		super(s, cause);
	}		
}
