/* Generated by Together */

package com.sap.caf.rt.ui.cool.generic;

import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.logging.Location;

/**
 * Realizes structured data for parameters of an <code>Action</code> or
 * <code>Query</code><p>
 * 
 * Additionally <code>Structure</code> implements <code>ICMIGenericModelClass</code> .<p>
 * This is necessary to use a <code>Structure</code> from Web Dynpro. Web Dynpro framework only knows this interface<p>
 * 
 * @author Helmut Mueller
 */

public class Structure extends AbstractModelClass implements IStructure {

	/** Logging properites for this class */
	private static final String APPLICATION	= Structure.class.getName();
	private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);

  /**
   * State of this structure. The state is not fully maintained by the structure itself. 
   * A call to makeClean() sets the state to CLEAN, write access to any attribute sets it to DIRTY.
   * Required by Query to determine chnages to its inupt parameters.
   */
  int state = Aspect.CLEAN;
  
  /**
   * The service module, this  structure belongs to
   */
  private final ServiceModule serviceModule;
  
  /**
   * The ICMIModelClassInfo for this structure. A reference is stored for performance reasons only. 
   * The info could be easily retrieved from the serviceModule whenever needed.
   */
  private final ICMIModelClassInfo modelClassInfo;
  
  /**
   * constructor, which builds a <code>Structure</code> from given <code>IEdoStructure</code>
   */
  protected Structure(ServiceModule serviceModule, IEdoStructure edoStructure )
  {
    if ( serviceModule == null )
      // ServiceModule must not be null
      throw new IllegalArgumentException("ServiceModule must not be null");
    if ( edoStructure == null )
      // wrapped data structure must not be null
      throw new IllegalArgumentException("Structure without valid data (EDO Structure) is not allowed!");
    this.serviceModule = serviceModule;  
    this.edoStructure = edoStructure;
    this.modelClassInfo = 
      ((ColModelInfo) serviceModule.associatedModelInfo()).getOrCreateModelClassInfo(getDescriptor());
    
  }

  /**
   * @see com.sap.tc.cmi.model.ICMIModelClass#associatedModel()
   */
  public ICMIModel associatedModel() {
    return (ICMIModel) serviceModule;
  }

  /**
   * @see com.sap.tc.cmi.model.ICMIGenericModelClass#associatedModelClassInfo()
   */
  public ICMIModelClassInfo associatedModelClassInfo() {
    return modelClassInfo;
  }

 /**
   * Returns the value of the attribute with given name as String or throws an <code>IllegalArgumentException</code>, if
   * attributeName is no valid name for an attribute.</p>
   * 
   * @param attributeName the name of the attribute
   * @return the value of the attribute with given name as String or throws an <code>IllegalArgumentException</code>, if
   * attributeName is no valid name for an attribute.
   */
  public String getAttributeAsString(String attributeName) {
    if ( getDescriptor().getFieldDescriptor(attributeName) == null )
      throw new IllegalArgumentException("attribute with name '"+attributeName+"' doesn't exist!");
    return edoStructure.getStringValue(attributeName);
  }
  
  /**
   * Returns the value of the attribute with given name as Object or throws an <code>IllegalArgumentException</code>, if
   * attributeName is no valid name for an attribute.</p>
   * Tha map of default values are used for digit types.
   * @param attributeName the name of the attribute 
   * @return Object the value of the attribute with given name as Object or throws an <code>IllegalArgumentException</code>, if
   * attributeName is no valid name for an attribute.
   */
  public Object getAttributeValue(String attributeName) {
    Object value = edoStructure.getValue(attributeName);
    if ( value == null ) {
      value = getDefaultValue(getDescriptor().getFieldDescriptor(attributeName));
    }
    return value;
  }

  Object getInternalValue(String attributeName){
  	Object v = ((EdoStructure)edoStructure).getValueInternal(((EdoStructure)edoStructure).getFieldIndex(attributeName));
	if( v != null )
		v = edoStructure.getValue(attributeName);
	return v;

  }


  /**
   * sets the given value to the attribute with given nameor throws an <code>IllegalArgumentException</code>, if
   * attributeName is no valid name for an attribute.</p>
   * @param attributeName the name of the attribute
   * @param value the value of the attribute as Object to set
   */
  public void setAttributeValue(String attributeName, Object attributeValue) {
    edoStructure.setValue( attributeName, attributeValue );
    // set state to dirty
    state = Aspect.DIRTY;
  }

  /**
   * Returns the value of the attribute to given index as String or throws an <code>IndexOutOfBoundsException</code>, 
   * if attributeIndex is no valide index.
   * @param attributeIndex the index of the attribute
   * @return String the value of the attribute to given index as String or throws an <code>IndexOutOfBoundsException</code>, 
   * if attributeIndex is no valide index.
   */
  public String getAttributeAsString(int attributeIndex) {
    return edoStructure.getStringValue(attributeIndex);
  }
  
  /**
   * Returns the value of the attribute to given index as Object or throws an <code>IndexOutOfBoundsException</code>, 
   * if attributeIndex is no valide index.</p> 
   * Tha map of default values are used for digit types.
   * @param attributeIndex the index of the attribute
   * @return Object the value of the attribute to given index as Object or throws an <code>IndexOutOfBoundsException</code>, 
   * if attributeIndex is no valide index.
   */
  public Object getAttributeValue(int attributeIndex) {
    Object value = edoStructure.getValue(attributeIndex);
    if ( value == null ) {
      value = getDefaultValue(getDescriptor().getFieldDescriptor(attributeIndex));
    }
    return value;
  }

  Object getInternalValue(int attributeIndex){
	Object v = ((EdoStructure)edoStructure).getValueInternal(attributeIndex);
  	if( v != null )
  		v = edoStructure.getValue(attributeIndex);
    return v;
  }



  /**
   * sets the given value to the attribute with given index or throws an <code>IndexOutOfBoundsException</code>.
   * @param attributeIndex the index of the attribute
   * @param value the value of the attribute as Object to set
   */
  public void setAttributeValue(int attributeIndex, Object attributeValue) {
    edoStructure.setValue( attributeIndex, attributeValue );
    // set state to dirty
    state = Aspect.DIRTY;
  }
  
  /**
   * Returns the meta data of this <code>Structure</code>.</p>
   * 
   * typically meta data are the name of the Structure and the meta data of the 
   * different fields (attributes).
   * 
   * @return IStructureDescriptor the meta data of this structure
   */
  public IStructureDescriptor getDescriptor() {
    return edoStructure.getDescriptor();
  }

  /**
   * Returns the number of fields in this <code>Structure</code>, which corresponds to the number
   * of Fields in <code>StructureDescriptor</code>.
   * It is only a shortcut for:
   * <pre>getDescriptor().size()</pre>.<p>
   * 
   * @return int the number of fields
   */
  public int size() {
    return getDescriptor().size();
  }
  
  /**
   * wrapped EDO Structure
   */
  private final IEdoStructure edoStructure;
	
  /**
   * Returns the srvMgrStructure.
   * @return ISrvMgrStructure
   */
  protected IEdoStructure getEdoStructure() {
    return edoStructure;
  }

  /**
   * Returns a string representation of this object.</p> 
   * Usage is recommended for tracing purposes only
   * @return String a string representation of this object
   */
  public String toString() {
    String nl = System.getProperty("line.separator");
    StringBuffer buf = new StringBuffer();
    buf.append("  <Structure>").append(nl);
    for( int i=0; i<size(); i++ ) {
      IFieldDescriptor field = getDescriptor().getFieldDescriptor(i);
      String attributeName = field.getName();
      String attributeValue = getAttributeAsString(i);
      if ( attributeValue != null )
        buf.append("     "+attributeName).append("=").append(attributeValue).append(nl);
      else
        buf.append("     "+attributeName).append("= <null>").append(nl);
        
    }
    buf.append("  </Structure>").append(nl);
    return buf.toString();
  }
  
  public boolean isDirty() {
    return state == Aspect.DIRTY;
  }
  
  public void makeClean() {
    state = Aspect.CLEAN;
  }

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IStructure#isAttributeInitial(int)
	 */
	public boolean isAttributeInitial(int arg0) {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IStructure#isAttributeInitial(java.lang.String)
	 */
	public boolean isAttributeInitial(String arg0) {
		// TODO Auto-generated method stub
		return false;
	}

}
