/*
 * Created on 08.12.2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.ui.cool.generic;

import java.util.Locale;

import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDMessageManager;
import com.sap.tc.webdynpro.services.sal.localization.api.WDResourceHandler;

/**
 * @author Pavel_Henrykhsen
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class MessageFactory {

	/** Logging properites for this class */
	private static final String APPLICATION	= MessageFactory.class.getName();
	private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);
	
	public static IMessage createAndRegisterMessageFromException(Throwable exception, IAspectRow row, String aspectFieldName) {
		return MessageFactory.createAndRegisterMessageFromException(exception, null, row, aspectFieldName, false);
	}

	public static IMessage createAndRegisterMessageFromException(Throwable exception, IQuery query, String aspectFieldName) {
		return MessageFactory.createAndRegisterMessageFromException(exception, getQueryResultAspect(query), null, aspectFieldName, false);
	}

	public static IMessage createAndRegisterMessageFromException(Throwable exception, IQuery query, String aspectFieldName, boolean isSystem) {
		return MessageFactory.createAndRegisterMessageFromException(exception, getQueryResultAspect(query), null, aspectFieldName, isSystem);
	}

	public static IMessage createAndRegisterMessageFromException(Throwable exception, IAspectRow row) {
		return MessageFactory.createAndRegisterMessageFromException(exception, row, null);
	}

	public static IMessage createAndRegisterMessageFromException(Throwable exception, IServiceFacade sf, boolean isSystem) {
		IMessage message = MessageFactory.createAndRegisterMessageFromException(exception, null, null, null, isSystem);
		registerMessage(exception, null, null, sf, message);
		return message;
	}

	public static IMessage createAndRegisterMessageFromException(Throwable exception, IServiceFacade sf) {
		return MessageFactory.createAndRegisterMessageFromException(exception, sf, false);
	}

	public static IMessage createAndRegisterMessageFromException(Throwable exception, IAspect aspect) {
		IMessage message = MessageFactory.createAndRegisterMessageFromException(exception, aspect, null, null, false);
		return message;
	}

	public static IMessage createAndRegisterMessageFromException(Throwable exception, IAspect aspect, boolean isSystem) {
		IMessage message = MessageFactory.createAndRegisterMessageFromException(exception, aspect, null, null, isSystem);
		return message;
	}

	private static IAspect getQueryResultAspect(IQuery query) {
		IAspect aspect = query.getResultAspect();
		return aspect;
	}

	protected static IMessage createAndRegisterMessageFromException(Throwable exception, IAspect aspect, IAspectRow row, String aspectFieldName, boolean isSystem) {
		final String method = jARMRequest + ":createAndRegisterMessageFromException(Throwable, IAspect, IAspectRow, String, boolean)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger);
		try {
			IMessage result;
			Throwable cause = exception;
			Throwable se = null;
			Throwable pe = null;
			while ((cause = cause.getCause()) != null) {
				if (cause instanceof ServiceException) {
					se = cause; // Remember the last Service Exception in the exception chain					
				} else if (se == null && cause instanceof CAFPermissionException) {
					pe = cause; // Remember the last Permission Exception in the chain
				}
			} 
			if (se == null) {
				// Check for permission exception and set original exception to report in case there are no Service Exceptions 
				// or Perpmission Exception in the chain
				se = pe == null ? exception : pe;  
			}
			boolean isOutOfBond = !(se instanceof ServiceException);
			isSystem = isSystem || se.getClass().getName().startsWith("java.lang.");
			
			String code = String.valueOf(se.hashCode());
			Locale current_locale = getCurrentSessionLocale();
			String text = null;
			if(se instanceof com.sap.exception.IBaseException){
				text = ((com.sap.exception.IBaseException)se).getLocalizedMessage(current_locale);
			}else
				text = 	se.getLocalizedMessage();
	
			if (text == null || text.length() == 0) {
				text = se.getMessage();
				if (text == null || text.length() == 0) {
					text = "The following exception occured while processing your request: " + se.toString() + ".";
				}
			}
			if (row != null || aspect != null) {
				result = new Message(IMessage.ERROR, code, text, null, isOutOfBond, true, aspectFieldName, isSystem, 
						false, row);
				registerMessage(se, aspect, row, null, result);
			} else if (aspect != null) {
				result = new Message(IMessage.ERROR, code, text, null, isOutOfBond, true, aspectFieldName, isSystem, 
						false, aspect);
				registerMessage(se, aspect, row, null, result);
			} else {
				result = new Message(IMessage.ERROR, code, text, null, isOutOfBond, true, aspectFieldName, isSystem, 
						false, (IAspectRow) null);
			}			
			return result;
		}
		finally {   
			CAFPublicLogger.exiting(null, jARMRequest, method, logger);
		}
	}

	public static void registerMessage(Throwable exception, IServiceFacade sf, IMessage result) {
		registerMessage(exception, null, null, sf, result);
	}
	
	public static void registerMessage(Throwable exception, IAspect aspect, IMessage result) {
		registerMessage(exception, aspect, null, null, result);
	}

	public static void registerMessage(Throwable exception, IAspectRow row, IMessage result) {
		registerMessage(exception, null, row, null, result);
	}

	public static void registerMessage(Throwable exception, IQuery query, IMessage result) {
		registerMessage(exception, query.getResultAspect(), null, null, result);
	}

	private static void registerMessage(Throwable exception, IAspect aspect, IAspectRow row, IServiceFacade sf, 
			IMessage result) {
		final String method = jARMRequest + ":registerMessage(Throwable, IAspect, IAspectRow, IServiceFacade, IMessage)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger);
		try {
			if (sf == null) {
				IServiceModule sm = null;
				if (row != null) {
					aspect = row.getAspect();
				}
				if (aspect != null) {
					sm = aspect.getServiceModule();
				}
				if (sm instanceof ServiceModule) {
					sf = ((ServiceModule) sm).getServiceFacade();
				}
			}
			if (row != null) {
				aspect = row.getAspect();
			}
			if (aspect != null) {
				IMessageList aspectMessages = aspect.getMessages();
				((MessageList) aspectMessages).addMessage(result);
			} else {
				if (sf == null) {
					throw new NullPointerException("IServiceFacade, IAspect or IAspectRow must be not null.");
				}
				MessageList mList = (MessageList)sf.getAllMessages();
				mList.addMessage(result);
			}
			if (result.getType() == IMessage.ERROR) {
				logger.catching(exception);
			} 
		}
		finally {   
			CAFPublicLogger.exiting(null, jARMRequest, method, logger);
		}
	}

	/**
	 * Method <code>reportOrRaiseCoolMessages</code> is a hepler method that should be used in UI components for reporting errors, warnings or just useful information to the user.
	 * It takes list of the messages generated by cool calls during processing such actions as execute() of IAction or IQuery, sendChanges() of IAspect or IServiceModule.
	 * @param list list of messages generated by cool during processing a call. The list is cleared after execution of the method.
	 * @param manager UI message manager to report or raise messages in.
	 * @param stopOnFirstFail if true, processing of messages is stoped just after first message with <code>Failed<code> flag set is encountered in the list. The rest of the messages in the list will not be processed. This flag does not have sence if <code>raise</code> flag is true. 
	 * @param cancelNavigation see IWDMessageManager for more details on the meaning of this flag.
	 * @param raise if the value is <code>true</code>, first error met in the list causes an WDNonFatalException to raise as described in IWDMessageManager methods <code>raise...</code> 
	 * @return status of the latest call. If equals <code>true</code> then the call is failed and the list contains fatal errors. See {@link #isFatal(IMessageList)} for details.
	 */
	public static boolean reportOrRaiseCoolMessages(IMessageList list, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation, boolean raise) {
		boolean result = false;
		int size = list.size();
		try {
			for (int i = 0; i < size; i++) {
				IMessage message = list.getMessage(i);
				switch (message.getType()) { 
					case IMessage.ERROR:
						if (raise) {
							manager.raiseException(message.getText(), cancelNavigation);
						} else {
							manager.reportException(message.getText(), cancelNavigation);
						}
						break;
					case IMessage.WARNING:
						manager.reportWarning(message.getText());
						break;
					case IMessage.INFO:
						manager.reportSuccess(message.getText());
						break;
					default:
						if (raise) {
							manager.raiseException("Unknown type of message has been recieved from <cool>. Message type: " + message.getType()
									+ ", message text: " + message.getText(), true);
						} else {
							manager.reportException("Unknown type of message has been recieved from <cool>. Message type: " + message.getType()
									+ ", message text: " + message.getText(), true);
						}
				}
				if (message.isFailed()) {
					result = true;
					if (stopOnFirstFail) {
						break;
					}
				}
			} 
		} finally {
			list.clear();
		}
		return result;
	}
	
	protected static Locale getCurrentSessionLocale(){
		Locale locale = WDResourceHandler.getCurrentSessionLocale();
		if (locale == null) {
			locale = Locale.getDefault();
		}
		return locale;
	}
}
