package com.sap.caf.rt.ui.cool.generic;

import java.lang.ref.WeakReference;

import java.lang.ref.Reference;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.core.SrvMgrMessage;

/**
 * @author d020684
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
class Message implements IMessage {

	private Reference m_aspectRow;
	private String m_aspectName;
	private int m_type;
	private String m_code;
	private String m_text;
	private Object m_extention;
	private String m_aspectFieldName;
	private boolean m_isOutOfBound;
	private boolean m_isFailed;
	private boolean m_isSystemMessage;
	private boolean m_isSystemConfirmation;

	public Message(ISrvMgrMessage msg) {
		this(msg.getType(), msg.getCode(), msg.getText(), msg.getExtension(), 
				msg.isOutbound(), msg.isFailed(), msg.getAspectField(), 
				false, false, msg.getAspectName());
	}

	public Message(int type, String code, String text, Object extention,
			boolean isOutOfBound, boolean isFailed, String aspectFieldName,
			boolean isSystemMessage, boolean isSystemConfirmation, IAspectRow aspectRow) {
		m_aspectRow = new WeakReference(aspectRow);
		m_type = type;
		m_code = code;
		m_text = text;
		m_extention = extention;
		m_aspectFieldName = aspectFieldName;
		m_isOutOfBound = isOutOfBound;
		m_isFailed = isFailed;
		m_isSystemMessage = isSystemMessage;
		m_isSystemConfirmation = isSystemConfirmation;
	}

	public Message(int type, String code, String text, Object extention,
			boolean isOutOfBound, boolean isFailed, String aspectFieldName,
			boolean isSystemMessage, boolean isSystemConfirmation, IAspect aspect) {
		this(type, code, text, extention, isOutOfBound, isFailed, 
				null, isSystemMessage, isSystemConfirmation, (IAspectRow) null);
		m_aspectName = aspect.getDescriptor().getName();
	}

	public Message(int type, String code, String text, Object extention,
			boolean isOutOfBound, boolean isFailed, String aspectFieldName,
			boolean isSystemMessage, boolean isSystemConfirmation, String aspectName) {
		this(type, code, text, extention, isOutOfBound, isFailed, 
				null, isSystemMessage, isSystemConfirmation, (IAspectRow) null);
		m_aspectName = aspectName;
	}

	public Message(int type, String text, boolean isFailed, String aspectFieldName, 
			IAspectRow aspectRow) {
		this(type, null, text, null, false, isFailed, aspectFieldName, false, false, aspectRow);
	}

	public Message(int type, String text, String aspectFieldName, 
			IAspectRow aspectRow) {
		this(type, null, text, null, false, type == IMessage.ERROR, aspectFieldName, false, false, aspectRow);
	}

	public Message(int type, String text) {
		this(type, null, text, null, false, type == IMessage.ERROR, null, false, false, (IAspectRow) null);
	}

	public Message(int type, String code, String text, Object extention,
			boolean isOutOfBound, boolean isFailed, boolean isSystemMessage, 
			boolean isSystemConfirmation) {
		this(type, code, text, extention, isOutOfBound, isFailed, 
				null, isSystemMessage, isSystemConfirmation, (IAspectRow) null);
	}
	
	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#getType()
	 */
	public int getType() {
		return m_type;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#isInfo()
	 */
	public boolean isInfo() {
		return getType() == IMessage.INFO;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#isWarning()
	 */
	public boolean isWarning() {
		return getType() == IMessage.WARNING;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#isError()
	 */
	public boolean isError() {
		return getType() == IMessage.ERROR;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#isFailed()
	 */
	public boolean isFailed() {
		return m_isFailed;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#getCode()
	 */
	public String getCode() {
		return m_code;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#getText()
	 */
	public String getText() {
		return m_text;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#getExtension()
	 */
	public Object getExtension() {
		return m_extention;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#isOutbound()
	 * @deprecated Name was misleading, use method isOutOfBand() instead.
	 */
	public boolean isOutbound() {
		return isOutOfBand();
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#isOutOfBand()
	 */
	public boolean isOutOfBand() {
		return m_isOutOfBound;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#getAspectRowKey()
	 */
	public IAspectRow getAspectRow() {
		return (IAspectRow) m_aspectRow.get();
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IMessage#getAspectFieldName()
	 */
	public String getAspectFieldName() {
		return m_aspectFieldName;
	}

	public IKey getAspectRowKey() {
		IAspectRow ar = (IAspectRow) m_aspectRow.get();
		if (ar != null) {
			return ar.getKey();
		} else {
			return null;
		}
	}

	/**
	 * Returns the values of message parameters as specified when creating this message.
	 * If no parameters have been specified, an empty array (String[0]) is returned.
	 */
	public String[] getVars() {
		return new String[] { String.valueOf(getType()), getCode(), 
				String.valueOf(getExtension()), String.valueOf(isOutOfBand()),
				String.valueOf(isFailed()), getAspectFieldName(),
				String.valueOf(isSystemMessage()),
				String.valueOf(isSystemMessageConfirm()) };
	}

	private String typeToString() {
		switch (getType()) {
			case IMessage.INFO:
				return "Info";
			case IMessage.WARNING:
				return "Warning";
			case IMessage.ERROR:
				return "Error";
			default:
				return "Undefined";
		}
	}

	public String toString() {

		StringBuffer buf = new StringBuffer("<Message");
		buf.append(" type=\"").append(typeToString()).append("\"");
		buf.append(" aspectRowKey=\"");
		if (getAspectRowKey() != null)
			buf.append(getAspectRowKey());
		buf.append("\"");
		buf.append(" text=\"").append(getText()).append("\"");
		buf.append(" field=\"").append(getAspectFieldName()).append("\"");
		buf.append(" />");

		return buf.toString();
	}

	public String getAspectName() {
		IAspectRow ar = getAspectRow();
		if (ar != null) {
			return ar.getDescriptor().getName();
		} else {
			return m_aspectFieldName;
		}
	}

	public boolean isAspectRowMessage() {
		return getAspectRow() != null;
	}

	public boolean isSystemMessage() {
		return false;
	}

	public boolean isSystemMessageConfirm() {
		return false;
	}

}
