package com.sap.caf.rt.ui.cool.generic;

import java.util.Collection;
import java.util.Map;

import com.sap.tc.cmi.metadata.CMICardinality;
import com.sap.tc.cmi.metadata.CMISetting;
import com.sap.tc.cmi.metadata.CMISettingDefinition;
import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.metadata.ICMIRelationInfo;
import com.sap.tc.cmi.metadata.ICMIRelationRoleInfo;
import com.sap.tc.logging.Location;

/**
 * represents the metadata of a model relation role at runtime
 * @author Helmut Mueller, Stephan Ritter
 */
public class ColModelRelationRoleInfo implements ICMIRelationRoleInfo {

	/** Logging properites for this class */
	private static final String APPLICATION	= ColModelRelationRoleInfo.class.getName();
	private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);


  private CMICardinality roleCardinality;
  private ColModelRelationRoleInfo sourceRole, targetRole;
  private String name;

  /**
   * @undirected
   * @supplierCardinality 1
   * @clientCardinality 0..*
   */
  private ColModelClassInfo modelClassInfo;

  /**
   * constructor for ColModelRelationRoleInfo.
   * @param name the role name of the relation
   * @param sourceModelClassInfo the meta data of the source model class of this relation
   * @param targetModelClassInfo the meta data of the target model class of this relation
   * @param wDCardinality the cardinality of the relation role
   */
  protected ColModelRelationRoleInfo( String name, ColModelClassInfo sourceModelClassInfo, ColModelClassInfo targetModelClassInfo,
    CMICardinality wDCardinality) {
    this.modelClassInfo = sourceModelClassInfo;
    this.roleCardinality = wDCardinality;
    targetRole = new ColModelRelationRoleInfo(name, targetModelClassInfo, this, wDCardinality); 
    this.name = name;
  }
  
  /**
   * private constructor ColModelRelationRoleInfo
   * @param the role name of the relation
   * @param targetModelClassInfo the meta data of the target model class of this relation
   * @param sourceRole the source role of the relation
   * @param wDCardinality the cardinality of the relation role
   */
  private ColModelRelationRoleInfo( String name, ColModelClassInfo targetModelClassInfo, ColModelRelationRoleInfo sourceRole, 
      CMICardinality wDCardinality) {
    this.modelClassInfo = targetModelClassInfo;
    this.roleCardinality = wDCardinality;
    this.sourceRole = sourceRole;
    this.name = name; 
  }

  /**
   * returns the model class info of the model class, to which the role belongs
   * @return ICMIModelClassInfo the model class info of the model class, to which the role belongs
   */
  public ICMIModelClassInfo getModelClassInfo() {
    return modelClassInfo;
  }

  /**
   * returns the other role. If <code>this</code> is the source role info,
   * the target role info is returned and vice versa.
   * the implementation derives this information from the corresponding
   * source role : target role association.
   */
  public ICMIRelationRoleInfo getOtherRoleInfo() {
    if (sourceRole == null) 
      return targetRole;
    else 
      return sourceRole;
  }

  /**
   * returns <code>null;</code>, cause this method is not supported.
   * @return ICMIModelRelationInfo <code>null;</code>, cause this method is not supported.
   */
  public ICMIRelationInfo getModelRelationInfo() {
    return null;
  }

  /**
   * returns the cardinality of the role according the defined CARDINALITY... constants.
   * 
   * @see CMICardinality
   * @return CMICardinality the cardinality of the role according the defined CARDINALITY
   */
  public CMICardinality getCardinality() {
    return roleCardinality;
  }

  /**
    * returns <code>true</code>, if role is the source role, otherwise <code>false</code>
    * @return boolean <code>true</code>, if role is the source role, otherwise <code>false</code>
    * @deprecated
   */
  public boolean isSourceRole() {
    if (sourceRole == null) return false;
    else return true;
  }

  /**
   * returns always <code>false</code>, cause there is no other information available
   * @return boolean always <code>false</code>, cause there is no other information available
   */
  public boolean isReadOnly() {
    return false;
  }

  /**
   * returns always <code>false</code>, cause there is no other information available
   * @return boolean always <code>false</code>, cause there is no other information available
   */
  public boolean isAggregation() {
    return false;
  }

  /**
   * returns <code>true</code>, if role is navigable
   * @return boolean <code>true</code>, if role is navigable
   */
  public boolean isNavigable() {
    return true;
  }

  /**
   * returns the name of the relation role
   * @return String the name of the relation role
   */
  public String getName() {
    return name;
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#getSetting(CMISettingDefinition)
   * throws <code>UnsupportedOperationException</code>
   */
  public CMISetting getSetting(CMISettingDefinition arg0) {
    throw new java.lang.UnsupportedOperationException();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#setSetting(CMISettingDefinition, String)
   * throws <code>UnsupportedOperationException</code>
   */
  public void setSetting(CMISettingDefinition arg0, String arg1) {
    throw new java.lang.UnsupportedOperationException();
  }
  
  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#getSettings()
   * throws <code>UnsupportedOperationException</code>
   */
  public Map getSettings() {
    throw new java.lang.UnsupportedOperationException();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#supports(String)
   * throws <code>UnsupportedOperationException</code>
   */
  public boolean supports(String arg0) {
    throw new java.lang.UnsupportedOperationException();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#supportedOptions()
   * throws <code>UnsupportedOperationException</code>
   */
  public Collection supportedOptions() {
    throw new java.lang.UnsupportedOperationException();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#addSupportedOption(String)
   * throws <code>UnsupportedOperationException</code>
   */
  public void addSupportedOption(String arg0) {
    throw new java.lang.UnsupportedOperationException();
  }

}
