package com.sap.caf.rt.ui.cool.generic;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptor;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.tc.cmi.metadata.CMISetting;
import com.sap.tc.cmi.metadata.CMISettingDefinition;
import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.metadata.ICMIModelClassPropertyInfo;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author pavel_ausianik
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
/**
 * Realizes meta data of a <COL> model class property at runtime.</p>
 * @author Helmut Mueller, Stephan Ritter
 */
public class ColModelClassPropertyInfo implements ICMIModelClassPropertyInfo {

	/** Logging properites for this class */
	private static final String APPLICATION	= ColModelClassPropertyInfo.class.getName();
	private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);
  
  /**
   * An internal map of data Types
   */
  private static Map dataTypes = new HashMap(23, 0.5f);
  
  /**
   * the wrapped <COL> <code>IFieldDescriptor<code>
   */
  private IFieldDescriptor fieldDescriptor;
  
  /**
   * the associated model class info
   * @undirected
   * @supplierCardinality 1
   * @clientCardinality 0..*
   */
  private ColModelClassInfo classInfo;
  
  /**
   * the field data type info
   */
  private IDataType dataType;
  
  /**
   * the field says that the property is read only
   */
  private boolean isReadOnly = false;

  
  /**
   * Constructor ColModelClassPropertyInfo.
   */
  public ColModelClassPropertyInfo(IFieldDescriptor fieldDescriptor, ICMIModelClassInfo classInfo) {
		final String method = jARMRequest + ":ColModelClassPropertyInfo(IFieldDescriptor, ICMIModelClassInfo)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			this.fieldDescriptor = fieldDescriptor;
			this.classInfo = (ColModelClassInfo) classInfo;
			if (fieldDescriptor instanceof TypedFieldDescriptor) {
				dataType = ((TypedFieldDescriptor)fieldDescriptor).getDataType(null, null);
			} else {
				dataType = fieldDescriptor.getSimpleType(); 
			}
			if (dataType!=null && dataType.isSimpleType()) {
				isReadOnly = ((ISimpleType) dataType).getReadOnly();
			}
		} catch (DdException e) {
			CAFPublicLogger.traceThrowable(Severity.ERROR,logger,method,e);
			throw new IllegalArgumentException(e.getLocalizedMessage());
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
  }


  /**
   * get associated meta data of model class
   * @return ICMIModelClassInfo associated meta data of model class
   */
  public ICMIModelClassInfo getModelClassInfo() {
    return classInfo;
  }

  /**
   * returns the data type of the property
   * @return IDataType the data type of the property
   */
  public IDataType getDataType() {
    return dataType;
  }

  /**
   * returns <code>true</code>, if property is read only, otherwise <code>false</code>
   * in the moment always <code>false</code> is returned
   * @return boolean <code>true</code>, if property is read only, otherwise <code>false</code>
   * in the moment always <code>false</code> is returned
   */
  public boolean isReadOnly() {
	return isReadOnly;
  }

  /**
   * returns the name of the property
   * @return String the name of the property
   */
  public String getName() {
    return fieldDescriptor.getName();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#getSetting(CMIModelSettingDefinition)
   */
  public CMISetting getSetting(CMISettingDefinition arg0) {
    throw new java.lang.UnsupportedOperationException();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#setSetting(CMIModelSettingDefinition, String)
   */
  public void setSetting(CMISettingDefinition arg0, String arg1) {
    throw new java.lang.UnsupportedOperationException();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#getSettings()
   */
  public Map getSettings() {
    throw new java.lang.UnsupportedOperationException();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#supports(String)
   */
  public boolean supports(String arg0) {
    throw new java.lang.UnsupportedOperationException();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#supportedOptions()
   */
  public Collection supportedOptions() {
    throw new java.lang.UnsupportedOperationException();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#addSupportedOption(String)
   */
  public void addSupportedOption(String arg0) {
    throw new java.lang.UnsupportedOperationException();
  }

}
