/*
 * Created on 15.04.2004
 */
package com.sap.caf.rt.ui.cool.generic;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.serviceaccess.SimpleDataContainer;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 *
 */
public class AspectServiceAccess {
	private static final String APPLICATION	= AspectServiceAccess.class.getName();
	private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);
	private static final String EMPTY_SUBMIT_ACTION_NAME = "$submit$";
	private static final String QUERY_FIND_BY_MULTIPLEPARAMETERS = "findByMultipleParameters";
	private static final String QUERY_FIND_BY_KMPROPERTYSEARCH = "findByKMPropertySearch";

	private CAFServiceManager manager;
	private IServiceModuleDescriptor descriptor;
	
	/**
	 * 
	 */
	public AspectServiceAccess(CAFServiceManager manager, IServiceModuleDescriptor descriptor) {
		this.manager = manager;
		this.descriptor = descriptor;
	}
	
	
	public IServiceModuleDescriptor getServiceModuleDescriptor(){
		return descriptor;
	}
	
	/**
	 * Read collection of  
	 * @param aspectName
	 * @param keys
	 * @return
	 * @throws ServiceException
	 */
	public Collection readAspectObjects(String aspectName, Collection keys) throws ServiceException{
		final String method = jARMRequest + ":readAspectObjects(String, Collection)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,1);
		
		Collection result = null;
		try{		
			Collection  dataObjects = manager.getServiceAccess().readDataObject(descriptor.getName(), aspectName, convertToObjectKeys(keys));
			result = dataObjects;
		}catch(RemoteException re){
			logger.throwing(re);
			throw new ServiceException(re);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
		return result;
	}

	/**
	 * Read target aspect
	 * @param targetAspect
	 * @param keys
	 * @return
	 * @throws ServiceException
	 */
	public Aspect readAspect(Aspect targetAspect, Collection keys) throws ServiceException{
		final String method = jARMRequest + ":readAspect(Aspect, Collection)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		
		Aspect result = targetAspect;
		try{					
			Collection  rawResult = manager.getServiceAccess().readDataObject(descriptor.getName(), targetAspect.getName(), convertToObjectKeys(keys));
			((Aspect)targetAspect).setState(Aspect.PROCESS_QUEUE_WAITING);
			 if (rawResult instanceof List) {
				Iterator it = ((List)rawResult).iterator();
				while(it.hasNext())
					createRow(targetAspect, (IDataContainerBean )it.next());		
			 }
			 else
				createRow(targetAspect, (IDataContainerBean )rawResult);
			((Aspect)targetAspect).setState(Aspect.CLEAN);

		}catch(RemoteException re){
			logger.throwing(re);
			throw new ServiceException(re);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
		return result;
	}
	
	/**
	 * Read relatred aspect by keys
	 * @param parentAspect
	 * @param relationName
	 * @param refKeys
	 * @return
	 * @throws ServiceException
	 */
	public Collection readRelatedAspects(String parentAspect, String relationName, Collection refKeys) throws ServiceException{
		final String method = jARMRequest + ":readRelatedAspects(String, String, Collection)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		
		if((refKeys == null) || (refKeys.isEmpty()))
			return new ArrayList();
		Collection result = null;
		IAspectDescriptor  asDesc = descriptor.getAspectDescriptor(parentAspect);
		IRelationDescriptor relDesc = asDesc.getRelationDescriptor(relationName);
		IAspectDescriptor refAspectDesc = relDesc.getTargetAspectDescriptor();
		result = this.manager.getAspectServiceAccess(refAspectDesc.getServiceModuleDescriptor().getName()).readAspectObjects(refAspectDesc.getName(), this.convertToObjectKeys(refKeys));
		CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		return result;
	}

	/**
	 * Update the collection of aspects.
	 * @param aspectRows
	 * @return
	 * @throws ServiceException
	 */
	public Collection updateAspects(Collection aspectRows)throws ServiceException{
		final String method = jARMRequest + ":updateAspects(Collection)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		
		Collection result =  aspectRows;
		int size = aspectRows.size();
		for(Iterator it = aspectRows.iterator(); it.hasNext();){
			updateAspect((AspectRow)it.next());
		}
		CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		return result;
	}

	/**
	 * Update aspect row
	 * @param row
	 * @return updated aspect row.
	 * @throws ServiceException
	 */
	public IAspectRow updateAspect(IAspectRow row)throws ServiceException{
		final String method = jARMRequest + ":updateAspect(IAspectRow)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		
		IDataContainerBean dcb = ((Aspect)row.getAspect()).getAspectData().
			getRecordDataBean(((AspectRow)row).getIndex());// this.createSimpleDataContainer(row);
		try{
			dcb = manager.getServiceAccess().updateDataObject(descriptor.getName(), row.getAspect().getDescriptor().getName(),dcb);
			this.refreshAspect(row, dcb);
		}catch(Exception e){
			handleException(e);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
		return row;
	}

	/**
	 * Insert collection of AspectRows
	 * @param rows - Collection of Aspect Rows
	 * @return <code>true</code> if operation is finished succesfully
	 * @throws ServiceException
	 */
	public boolean insertAspectRows(Collection rows) throws ServiceException{
		final String method = jARMRequest + ":insertAspectRows(Collection)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
			boolean result = false;
		for(Iterator it = rows.iterator(); it.hasNext(); ){
			Object v = it.next();
			result = result && insertAspectRow((IAspectRow)v);
		}
		CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		 return result;
	}

	/**
	 * Insert AspectRow 
	 * @param row Aspect row to insert
	 * @return  <code>true</code> if operation is finished succesfully
	 * @throws ServiceException
	 */
	public boolean insertAspectRow(IAspectRow row) throws ServiceException{
		final String method = jARMRequest + ":insertAspectRow(IAspectRow)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		boolean result = false;
		IDataContainerBean dcb = ((Aspect)row.getAspect()).getAspectData().
			getRecordDataBean(((AspectRow)row).getIndex());// this.createSimpleDataContainer(row);
		try{
			dcb = manager.getServiceAccess().createDataObject(descriptor.getName(), row.getAspect().getDescriptor().getName(),dcb);
			this.refreshAspect(row, dcb);
			result = false;
		}catch(Exception e){
			handleException(e);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
		return result;
	}

	
	/**
	 * Delete aspects rows with given keylist
	 * @param aspectName
	 * @param keys
	 * @return  <code>true</code> if operation is finished succesfully
	 * @throws ServiceException
	 */
	public boolean deleteAspectRows(String aspectName, IKeyList keys) throws ServiceException{
		final String method = jARMRequest + ":deleteAspectRows(String, IKeyList)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		
		boolean result = false;
		try{
			Collection keysV = this.convertToObjectKeys(keys);
			result = manager.getServiceAccess().deleteDataObject(descriptor.getName(), aspectName, keysV);
		}catch(Exception e){
			handleException(e);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
		return result;
	}
	
	/**
	 * Invoke query with given and and for defined aspect. 
	 * @param aspectName - aspect name
	 * @param query = query name
	 * @param parameters - parameters
	 * @return 
	 * @throws ServiceException
	 */
	public Collection findBy(String aspectName, String query, IStructure parameters) throws ServiceException{
		final String method = jARMRequest + ":findBy(String, String, IStructure)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		
		Collection result = null;
		Collection pars = null;
		if(QUERY_FIND_BY_KMPROPERTYSEARCH.equals(query) || QUERY_FIND_BY_MULTIPLEPARAMETERS.equals(query)){
			pars = convertToParametersWithNulls(parameters);
		}else{		
			pars = convertToParameters(parameters);
		}

		try{		
			result = manager.getServiceAccess().findByDataObject(descriptor.getName(), query, pars);
		}catch(RemoteException re){
			Throwable  ce  =re.getCause();
			if(ce instanceof ServiceException ){
				throw (ServiceException)ce;
			}else if(ce == null){
				throw new ServiceException(re);
			}else{
				throw new ServiceException(ce);
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
		return result;
	}
	/**
	 * Return Value Help
	 * @param aspectName
	 * @param attribute
	 * @return
	 * @throws ServiceException
	 */
	public IAspect valueHelp(String aspectName, String attribute)throws ServiceException{
		final String method = jARMRequest + ":valueHelp(String, String)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,2);
		
		IAspect result = null;
			//TODO implement getting ValueHelp
		CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
			return result;
	}
	
	/**
	 * Invoke method to refresh values that calculated on server side
	 * @param row - given aspect row
	 * @throws ServiceException
	 */
	public void recalculate(IAspectRow row)throws ServiceException {
		//TODO implement recalculcation
	}
	
	/**
	 * Invoke custom operation with given structure of parameters
	 * @param operationName
	 * @param parameters
	 * @return result of operation
	 * @throws ServiceException
	 */
	public Object invokeOperation(String operationName, IStructure parameters, IKeyList keys) throws ServiceException{
		final String method = jARMRequest + ":invokeOperation(String, IStructure, IKeyList)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		Object result = null;

		try {
			if(!EMPTY_SUBMIT_ACTION_NAME.equals(operationName)) {
				//implement invokation
				Collection pars = convertToParameters(parameters);
			
				Collection keysV = this.convertToObjectKeys(keys);
				
				// commit all changes before
				result = manager.getServiceAccess().invokeCustom(descriptor.getName(),
					operationName, pars, keysV);
			}
		} catch(RemoteException re) {
			Throwable  ce  =re.getCause();
			if(ce instanceof ServiceException ){
				throw (ServiceException)ce;
			}else if(ce == null){
				throw new ServiceException(re);
			}else{
				throw new ServiceException(ce);
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
				
		return result;
	}
	
	/**
	 * invoke custom action with gived arra of parameters
	 * @param operationName
	 * @param parameters
	 * @return result of operation.
	 * @throws ServiceException
	 */
	public Object invokeOperation(String operationName, Object[] parameters, IKeyList keys) throws ServiceException{
		final String method = jARMRequest + ":invokeOperation(String, Object[])";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		
		Object result = null;
		//implement invokation
		try{
			Collection keysV = this.convertToObjectKeys(keys);
					
			result = manager.getServiceAccess().invokeCustom(descriptor.getName(),
				operationName, parameters, keysV);
		}catch(RemoteException re){
			Throwable  ce  =re.getCause();
			if(ce instanceof ServiceException ){
				throw (ServiceException)ce;
			}else if(ce == null){
				throw new ServiceException(re);
			}else{
				throw new ServiceException(ce);
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
		return result;
	}
	
	
	/**
	 * Refresh aspect by DataContainerBean
	 * @param row
	 * @param data
	 */
	void refreshAspect(IAspectRow row, IDataContainerBean data){
		((AspectRow)row).supplyRowWithData(data);		
	}
	
	/**
	 * create AspectRow in given aspect, fill attribtues by given bean.
	 * @param result - target aspect
	 * @param bean - bean with data
	 */	
	void createRow(IAspect result, IDataContainerBean  bean) {
		final String method = jARMRequest + ":createRow(IAspect, IDataContainerBean)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		
		  try {
			  AspectRow row = (AspectRow)((Aspect)result).createAspectRow();
			  row.supplyRowWithData(bean);
		  }
		  finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		  }
	}
	

	/**
	 * Create instance of SimpleDataContainerBean with values of given aspect
	 * @param row
	 * @return instance of SimpleDataContainerBean
	 */	
	protected IDataContainerBean createSimpleDataContainer(IAspectRow row){
		IDataContainerBean result = new SimpleDataContainer();
		((AspectRow)row).refreshData(result);
		return result;
	}
	
	
	protected Object convertToObjectKey(IKey key){
		Object result = key.toString();
		return result;
	}
	
	/**
	 * Convert IKeyList to collection of keys that can be pass on servive layer.
	 * @param keyList
	 * @return collection of String
	 */
	protected Collection convertToObjectKeys(Collection keyList){
		if(keyList instanceof IKeyList){
			ArrayList result = new ArrayList(keyList.size());
			for(int i=0; i< keyList.size(); i++){
				result.add(convertToObjectKey(((IKeyList)keyList).getKey(i)));
			}
			return result;
		}
		return keyList;
	}
	
	/**
	 * Convert structure object to collection of parameters
	 * @param structure
	 * @return
	 */
	protected Collection convertToParameters(IStructure structure){
		Collection result = new ArrayList();
		int size = structure.size();
		for(int  i = 0; i< size; i++){
			result.add(structure.getAttributeValue(i));
		}
		return result;		
	}

	/**
	 * Convert structure object to collection of parameters. Special support of "findByMultipleParameters" and "KMPropertySearch"
	 * @param structure
	 * @return
	 */
	protected Collection convertToParametersWithNulls(IStructure structure){
		Collection result = new ArrayList();
		Structure struct = (Structure) structure;
		int size = struct.size();
		for(int  i = 0; i< size; i++){
			result.add(struct.getInternalValue(i));
		}
		return result;		
	}

	
	/**
	 * Throw instance of ServiceException by given exception. If input parameters instance of ServiceException - throw it.
	 * @param e
	 * @throws ServiceException
	 */
	protected void handleException(Exception e) throws ServiceException{
		final String method = jARMRequest + ":handleException(e)";
		if(e instanceof InvocationTargetException){
			e = (Exception)((InvocationTargetException)e).getCause();
		}
		if(!(e instanceof ServiceException) ){
			e = new ServiceException(e);
		}
		CAFPublicLogger.traceThrowableT(
			Severity.DEBUG,
			logger,
			method,
			"Error in " + method,
			e);
		logger.throwing(method, e);
		throw (ServiceException)e;
	}
	
}
