/* Generated by Together */

package com.sap.caf.rt.ui.cool.generic;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.serviceaccess.SimpleDataContainer;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.metadata.AspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptor;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.cmi.metadata.CMICardinality;
import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.ILockState;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.logging.Location;

/**
 * realizes a class for a row of an <code>Aspect</code>
 * 
 * The data of a <code>ServiceModule</code> is accessible at runtime in form of various <code>Aspect</code>s.
 * Each  <code>Aspect</code> contains a collection of  <code>AspectRow</code>'s, which all have the same structure.<p>
 * 
 * An <code>AspectRow</code> always has a unique <code>Key</code>, where <code>Key</code>, itself is derived from <code>AspectRow</code>.<p> 
 * Likewise the <code>Aspect</code>, it has methods to navigate to related <code>Aspect</code>s and <code>AspectRow</code>s.
 * 
 * Additionally <code>AspectRow</code> implements <code>ICMIGenericModelClass</code>.<p>
 * This is necessary to use it as ModelClass from Web Dynpro. Web Dynpro framework only knows this interfaces.
 * 
 * @see Aspect 
 * @author Helmut Mueller
 */
public class AspectRow extends AbstractModelClass implements IAspectRow {

	/** Logging properites for this class */
	private static final String APPLICATION	= AspectRow.class.getName();
	private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);
	
//	private boolean isNeedLoad = false; 
	
	/**
	 * constructor creates an empty <code>AspectRow</code>, where all attributes (elements)
	 * have value <code>null</code>
	 * @deprecated Use constructor with key instead.
	 */
	protected AspectRow(Aspect aspect, int index) {
		this(aspect, index, new Key(aspect.getDescriptor().getKeyDescriptor()));
	}

	/**
	 * constructor creates an empty <code>AspectRow</code>, with a known Key
	 */
	protected AspectRow(Aspect aspect, int index, Key key) {
		this.aspect = aspect;
		this.index = index;
		// remember given key
		this.key = key;
		
		int size = aspect.getDescriptor().getStructure().size();
		this.loadedAttributes = new BitSet(size);
		this.loadedAttributes.set(0, size);
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IStructure#getDescriptor()
	 */
	public IStructureDescriptor getDescriptor() {
		return aspect.getDescriptor().getStructure();
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IStructure#size()
	 */
	public int size() {
		return getDescriptor().size();
	}

	/**
	 * Delegates to Aspect.
	 * @see com.sap.tc.cmi.model.ICMIModelClass#associatedModel()
	 */
	public ICMIModel associatedModel() {
		return aspect.associatedModel();
	}

	/**
	 * Delegates to Aspect.
	 * @see com.sap.tc.cmi.model.ICMIGenericModelClass#associatedModelClassInfo()
	 */
	public ICMIModelClassInfo associatedModelClassInfo() {
		return aspect
			.associatedModelObjectCollectionInfo()
			.getElementModelClassInfo();
	}

	/**
	 * The field equals true if there is inconsistence between aspect data and key fields in the key.
	 */
	protected boolean m_keyFieldsChanged;
	
	/**
	 * the  <code>Aspect</code> this <code>AspectRow</code> belongs to
	 * @shapeType AssociatesLink
	 * @label
	 * @supplierCardinality 0..1
	 * @clientCardinality 0..*
	 * @directed
	 */
	private final Aspect aspect;

	/**
	 * the unique <code>Key</code> of this <code>AspectRow</code>
	 * @shapeType AssociatesLink 
	 * @label
	 * @supplierCardinality 1
	 * @clientIKeydinality 0..1
	 * @clientCardinality 0..*
	 * @bidirectional <{com.sap.tc.col.client.generic.core.Key#aspectRow}>
	 * @directed*/
	private final Key key;

	/**
	 * the flag for calulating of parameters on the fly <code>recalculateTrigger</code> of this <code>AspectRow</code>
	 * */
	private boolean recalculateTrigger = true;

	private BitSet loadedAttributes;  
	/**
	 * Returns the unique <code>Key</code> of this <code>AspectRow</code>
	 * @return IKey the unique <code>Key</code> of this <code>AspectRow</code>
	 */
	public IKey getKey() {
		final String method = jARMRequest + ":getKey()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,2);
		try {
			handleAccessAspectRow();
			if (m_keyFieldsChanged) {
				IKeyAspectDescriptor keyDescriptor = key.getKeyDescriptor();
				IStructureDescriptor structure = keyDescriptor.getStructure();
				int noOfKeyFields = structure.size();
				String[] sKeyFields = new String[noOfKeyFields];
				for (int i = 0; i < noOfKeyFields; i++) {
					String keyField = structure.getFieldDescriptor(i).getName();
					sKeyFields[i] = (String)getAttributeValue(keyField); 
				}
				key.setKeyFields(sKeyFields);
				m_keyFieldsChanged = false;
			}
			return key;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger,2 );
		}
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getRelatedAspect(String, String)
	 */
	public IAspect getRelatedAspect(
		String relationName,
		String targetAspectName) {
		return getRelatedAspect(relationName, targetAspectName, LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * Return related aspect
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getRelatedAspect(String, String, LockMode)
	 */
	public IAspect getRelatedAspect(
		String relationName,
		String targetAspectName,
		LockStrategy lockMode) {
		final String method = jARMRequest + ":getRelatedAspect(String, String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,1);
		try {
			IRelationDescriptor relationDescriptor =
				aspect.getRelationDescriptorOrFail(relationName);
			String targetOfRelation =
				relationDescriptor.getTargetAspectDescriptor().getName();
			if (targetOfRelation.equals(targetAspectName)) {
				return getRelatedAspect(relationName, lockMode);
			} else {
				Aspect targetAspect =
					(Aspect) getRelatedAspect(relationName, LockStrategy.SHARED_READ_ONLY);
				return targetAspect.getAspect(targetAspectName, lockMode);
			}
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
	}

	/**
	 * Return related aspect row
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getRelatedAspectRow(String, String)
	 */
	public IAspectRow getRelatedAspectRow(
		String relationName,
		String targetAspectName) {
		return getRelatedAspectRow(
			relationName,
			targetAspectName,
			LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getRelatedAspectRow(String, String, LockMode)
	 */
	public IAspectRow getRelatedAspectRow(
		String relationName,
		String targetAspectName,
		LockStrategy lockMode) {
		final String method = jARMRequest + ":getRelatedAspectRow(String, String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			IRelationDescriptor relationDescriptor =
				aspect.getRelationDescriptorOrFail(relationName);
			String targetOfRelation =
				relationDescriptor.getTargetAspectDescriptor().getName();
			if (targetOfRelation.equals(targetAspectName)) {
				return getRelatedAspectRow(relationName, lockMode);
			} else {
				AspectRow targetAspectRow =
					(AspectRow) getRelatedAspectRow(relationName,
						LockStrategy.SHARED_READ_ONLY);
				return targetAspectRow.getAspectRow(targetAspectName, lockMode);
			}
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getRelatedAspect(String)
	 */
	public IAspect getRelatedAspect(String relationName) {
		return getRelatedAspect(relationName, LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * Get Related aspect from cache or null if not found
	 * @param relationName
	 * @param lockMode
	 * @return instance of populated aspect instnace or <code>null</code>.
	 * @throws ServiceException
	 * @throws InvocationTargetException
	 * @throws IllegalAccessException
	 */
	protected IAspect getRelatedFromCache(String relationName, LockStrategy lockMode) throws ServiceException, InvocationTargetException, IllegalAccessException {
		// first look, whether relation is cached
		final String method = jARMRequest + ":getRelatedFromCache(String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			Aspect targetAspect =
				dependantAspectCache.getRelatedAspect(relationName);
			if (targetAspect != null) {
					if (lockMode != LockStrategy.SHARED_READ_ONLY) {
					// first check, whether target has a state, where LOCKING is allowed
					if (targetAspect.getState() != Aspect.CLEAN
						&& targetAspect.getState() != Aspect.HOLLOW) {
						throw new IllegalArgumentException(
							"Locking of aspect '"
								+ targetAspect.getName()
								+ "' not allowed, cause Aspect is not CLEAN or HOLLOW!");
					}
					// refresh the target Aspect
					//TODO remove create related aspect , this method gets from cache only 
					//targetAspect = (Aspect) createAndPopulateRelatedAspect(relationName, lockMode);
				}
			} else {
				IRelationDescriptor relationDescriptor =
					aspect.getRelationDescriptorOrFail(relationName);
				// to differentiate, whether relation starts from AspectRow or Key
				String sourceAspectName =
					relationDescriptor.getSourceAspectDescriptor().getName();
				if (!sourceAspectName.equals(aspect.getName())) {
					// relation starts from Key
					Aspect keyAspect = (Aspect) aspect.getAspect(sourceAspectName);
					IAspectRow keyAspectRow = keyAspect.getAspectRow(key);
					if (keyAspectRow == null) {
						keyAspectRow = keyAspect.createAspectRow((IKey) key);
					}
					return keyAspectRow.getRelatedAspect(relationName, lockMode);
				}
			}
			return targetAspect;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Create and populate related aspect
	 * @param relationName - name of relation
	 * @param lockMode - lock mode
	 * @return populated instance of related aspect
	 * @throws ServiceException
	 * @throws InvocationTargetException
	 * @throws IllegalAccessException
	 */
	protected IAspect createAndPopulateRelatedAspect(String relationName, LockStrategy lockMode) throws ServiceException, InvocationTargetException, IllegalAccessException {
		final String method = jARMRequest + ":createAndPopulateRelatedAspect(String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try {
			IAspect targetAspect = createTargetAspect(relationName);
			populateRelatedAspect(relationName,lockMode, targetAspect);
			dependantAspectCache.addRelatedAspect(
				this,
				relationName,
				(Aspect)targetAspect,
				null);
			return targetAspect;	
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
	}

	/**
	 * Create related aspest by relation name. Look descriptor of related aspect, create instance of Aspect by desciptor.
	 * @param relationName- name of relation
	 * @return empty instance of Aspect.
	 */
	private IAspect createTargetAspect(String relationName) {
		final String method = jARMRequest + ":createTargetAspect(String)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			IAspect targetAspect;
			IRelationDescriptor relationDescriptor =
				aspect.getRelationDescriptorOrFail(relationName);
			
			IAspectDescriptor targetDesc =
				relationDescriptor.getTargetAspectDescriptor();
			
			// get service module
			ServiceModule serviceModule =
				(ServiceModule) aspect.getServiceModule();
			ServiceFacade facade = serviceModule.getServiceFacade();
			IServiceModule targetServiceModule =
				facade.getServiceModule(
					targetDesc.getServiceModuleDescriptor().getName());
			targetAspect =
				(Aspect) targetServiceModule.createAspect(targetDesc.getName());
			return targetAspect;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Populate related aspect defined in <code>targetAspect</code> parameter
	 * @param relationName - name of relation
	 * @param lockMode - lock mode, instance of LockStrategy object
	 * @param targetAspect - related aspect collection
	 * @throws ServiceException - occurs in case of exception with communication layer of services
	 * @throws InvocationTargetException
	 * @throws IllegalAccessException
	 */
	protected void populateRelatedAspect(String relationName , LockStrategy lockMode, IAspect targetAspect) throws ServiceException, InvocationTargetException, IllegalAccessException {
		final String method = jARMRequest + ":populateRelatedAspect(String, LockStrategy, IAspect)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,1);
		try {
			// get service module
			ServiceModule serviceModule =
				(ServiceModule) aspect.getServiceModule();
			IRelationDescriptor relationDescriptor = aspect.getRelationDescriptorOrFail(relationName);
			String relationAttribute = Util.getSourceRelationAttribute(relationDescriptor);
			
//			loadRowDataIfNecessary();
			Object refObject = aspect.getAspectData().getRecordDataBean(index).getProperty(relationAttribute);

			if("true".equals(relationDescriptor.getAttributeStringValue("complex_attribute"))) {
				((Aspect) targetAspect).setState(Aspect.PROCESS_QUEUE_WAITING);
				if (refObject instanceof Collection) {
					Iterator it = ((Collection) refObject).iterator();
					while (it.hasNext()) {
						Object value = it.next();
						if(value!=null) {
							createRow(targetAspect, (IDataContainerBean) value);
						}
					}
				} else {
					if(refObject!=null) {
						createRow(targetAspect, (IDataContainerBean) refObject);
					}
				}
				((Aspect) targetAspect).setState(Aspect.CLEAN);
			} else if("true".equals(((AspectDescriptor)((Aspect) targetAspect).
				getDescriptor()).getAttributeStringValue("collection_support"))) {
				if (refObject != null)
				{
					//Object key = aspect.getAspectData().getRecordDataBean(index).getProperty("key");
					((Aspect) targetAspect).setState(Aspect.PROCESS_QUEUE_WAITING);
					if (refObject instanceof Collection) {
						Iterator it = ((Collection) refObject).iterator();
						while (it.hasNext()) {
							SimpleDataContainer sc = new SimpleDataContainer();
							//sc.setProperty("key", key);
							sc.setProperty("value", it.next());
							
							createRow(targetAspect, sc);
						}
					}
					((Aspect) targetAspect).setState(Aspect.CLEAN);
				}	
			} else {
				if (refObject != null)
				{
					Collection refKeys = null;
					if(refObject instanceof Collection){
						refKeys =  ((Collection)refObject).isEmpty() ? null : (Collection) refObject;
					}else{
						refKeys = new HashSet();
						if((refObject != null) && (!"".equals(((String)refObject).trim())))
							refKeys.add(refObject);
					}
					if (refKeys != null)
					{
/*  the loading of related aspects by first request was disable because bwas bug CSN 588619
						int size = relationDescriptor.getTargetAspectDescriptor().
							getKeyDescriptor().getStructure().size();
						if(size>1) {
*/
							Object rawResult =  serviceModule.getAspectServiceAccess().readRelatedAspects(aspect.getName(), relationName, refKeys );
						
							((Aspect) targetAspect).setState(Aspect.PROCESS_QUEUE_WAITING);
							if (rawResult instanceof Collection) {
								Iterator it = ((Collection) rawResult).iterator();
								while (it.hasNext()) {
									createRow(targetAspect, (IDataContainerBean) it.next());
								}
							} else {
								createRow(targetAspect, (IDataContainerBean) rawResult);
							}
							((Aspect) targetAspect).setState(Aspect.CLEAN);
/* the loading of related aspects by first request was disable because bwas bug CSN 588619
						} else {						
							((Aspect) targetAspect).setState(Aspect.PROCESS_QUEUE_WAITING);
							for(Iterator it = refKeys.iterator(); it.hasNext();) {
								String key = (String) it.next();
								AspectRow row = (AspectRow)targetAspect.
									createAspectRow(
										new Key(targetAspect.getDescriptor().getKeyDescriptor(), 
											new String[] {key}));
								row.isNeedLoad = true;
							}
							((Aspect) targetAspect).setState(Aspect.CLEAN);
						}
*/
					}
				}
			}
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
	}


	/**
	 * @see com.sap.tc.col.client.generic.api.IAspect#getRelatedAspect(String, LockMode)
	 */
	public IAspect getRelatedAspect(String relationName, LockStrategy lockMode) {
		final String method = jARMRequest + ":getRelatedAspect(String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		IAspect targetAspect = null;
		try {
			// navigation on HOLLOW Aspects via performance booster
			if (state != Aspect.HOLLOW)
				handleAccessAspectRow();

			// first look, whether relation is cached
			targetAspect = getRelatedFromCache(relationName, lockMode);
			if (targetAspect == null) {
				targetAspect = createAndPopulateRelatedAspect(relationName, lockMode);
			}
			aspect.addRelatedAspect(targetAspect);
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
			try {
				targetAspect = createTargetAspect(relationName); // Try our best to return not null aspect.
			} catch (Exception e2) {
				MessageFactory.createAndRegisterMessageFromException(e, this);
			}
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
		return targetAspect; 
	}

	//TODO move to util class
	private void createRow(IAspect result, IDataContainerBean bean) {
		AspectRow row = (AspectRow)result.createAspectRow();
		row.supplyRowWithData(bean);
	}

	
	public void supplyRowWithData(IDataContainerBean data){
		setAttributeValue(data);
	}

	/**
	 * refresh given data container by values of aspect row
	 * @param data instance of IDataContainerBean.
	 */	
	public void refreshData(IDataContainerBean data){
		IDataContainerBean row = aspect.getAspectData().getRecordDataBean(index);
		IStructureDescriptor desc = aspect.getDescriptor().getStructure();
		IFieldDescriptor[] descs = desc.getFieldDescriptors();
		for(int i = 0; i < descs.length; i++){
			data.setProperty(descs[i].getName(), row.getProperty(descs[i].getName()));
		}
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getRelatedAspectRow(String)
	 */
	public IAspectRow getRelatedAspectRow(String relationName) {
		return getRelatedAspectRow(relationName, LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getRelatedAspectRow(String, LockMode)
	 */
	public IAspectRow getRelatedAspectRow(
		String relationName,
		LockStrategy lockMode) {
		final String method = jARMRequest + ":getRelatedAspectRow(String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			// first check cardinality of Relation
			IRelationDescriptor relationDescriptor =
				aspect.getRelationDescriptorOrFail(relationName);
			CMICardinality cardinality =
				relationDescriptor.getAttributeTargetCardinality();
			if (cardinality.isMultiple()) {
				throw new IllegalArgumentException(
					" Cardinality of relation "
						+ relationName
						+ " has to be 1:0..1 but is "
						+ cardinality);
			}
			Aspect targetAspect =
				(Aspect) getRelatedAspect(relationName, lockMode);
			if (targetAspect != null && targetAspect.size() > 0)
				return targetAspect.getAspectRow(0);
			else
				return null;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Add related model
	 */
	public boolean addRelatedModelObject(String rolename, ICMIModelClass o) {
		boolean result = false;
		if((rolename != null) && (o instanceof AspectRow )){
			AspectRow relRow = (AspectRow)o;
			IRelationDescriptor r_desc = aspect.getDescriptor().getRelationDescriptor(rolename);
			Aspect asp = (Aspect)this.getRelatedAspect(rolename);
			result = asp.createRelatedAspectRow(relRow) != null;
			this.handleDirtyState("key");
			this.setState(Aspect.DIRTY);
		}
		return result;		
	}
	
	/**
	 * Set related model object
	 * @param roleName
	 * @param o
	 */
	public void setRelatedModelObject(String roleName, ICMIModelClass o){
		final String method = jARMRequest + ":setRelatedModelObject(String, ICMIModelClass)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try{		
			if(o instanceof AspectRow){
				IAspect old = this.getRelatedFromCache(roleName, LockStrategy.SHARED_READ_ONLY);
				if(old != null){
					old.invalidate();
				}
				IAspect targetAspect = createTargetAspect(roleName);
				dependantAspectCache.addRelatedAspect(this, roleName, (Aspect)targetAspect, null);
				addRelatedModelObject(roleName, (ICMIModelClass)o);
				this.handleDirtyState("key");
				this.setState(Aspect.DIRTY);
			}
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}			
	}

	/**
	 * Set related aspect
	 */
	public void setRelatedModelObjects(String roleName, Collection o) {
		final String method = jARMRequest + ":setRelatedModelObject(String, Collection)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,1 );

		try{		
			if(o instanceof Aspect){
				IAspect old = this.getRelatedFromCache(roleName, LockStrategy.SHARED_READ_ONLY);
				if(old != null){
					old.invalidate();
				}
				dependantAspectCache.addRelatedAspect(
					this,
					roleName,
					(Aspect)o,
					null);
				aspect.addRelatedAspect((IAspect)o);
				this.handleDirtyState("key");
				this.setState(Aspect.DIRTY);
			}
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}	

	}


	/**
	 * Remove related aspect
	 */
	public boolean removeRelatedModelObject(String roleName, ICMIModelClass o){
		final String method = jARMRequest + ":removeRelatedModelObject(String, ICMIModelClass)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);		 
		try{
			if((roleName != null) && (o instanceof AspectRow )){
				AspectRow relRow = (AspectRow)o;
				IRelationDescriptor r_desc = aspect.getDescriptor().getRelationDescriptor(roleName);
				Aspect asp = (Aspect)this.getRelatedAspect(roleName);
				int current_state = asp.getState();
				try{
					asp.setState(Aspect.DIRTY_PENDING);				
					asp.removeAspectRow(relRow);
					this.handleDirtyState("key");
				}finally{
					asp.setState(current_state);
					this.setState(Aspect.DIRTY);	
				}

				return true;				
			}
		}finally{
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
		return false;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getAspectRow(String)
	 */
	public IAspectRow getAspectRow(String aspectName) {
		return getAspectRow(aspectName, LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getAspectRow(String, LockMode)
	 */
	public IAspectRow getAspectRow(String aspectName, LockStrategy lockMode) {
		final String method = jARMRequest + ":getAspectRow(String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			handleAccessAspectRow();
			AspectRow targetRow;
	
			Aspect resultAspect = dependantAspectCache.getSiblingAspect(aspectName);
	
			// look whether AspectRow is cached
			if (resultAspect != null) {
				return resultAspect.getAspectRow(getKey(), lockMode);
			}
	
			// look whether Aspect is buffered in associated Aspect
			resultAspect = aspect.getSelectedAspect(aspectName);
			if (resultAspect != null) {
				return resultAspect.getAspectRow(getKey(), lockMode);
			}
	
			ServiceModule serviceModule = (ServiceModule) aspect.getServiceModule();
	
			// build singleton KeyList with our key
			KeyList keyList = new KeyList(key.getKeyDescriptor());
			keyList.add(key);
	
			// select aspect data by key
			resultAspect =
				(Aspect) serviceModule.getAspect(
					aspect,
					aspectName,
					keyList,
					lockMode);
	
			if (resultAspect.getState() == Aspect.CLEAN) {
				// Aspect was locally created
				targetRow = (AspectRow) resultAspect.getAspectRow(key);
			} else {
				// create one HOLLOW target AspectRow
				// set state of Aspect to avoid HOLLOW and DIRTY handling
				resultAspect.setState(Aspect.PROCESS_QUEUE_WAITING);
				targetRow = (AspectRow) resultAspect.createAspectRow(0);
				resultAspect.setState(Aspect.HOLLOW);
				targetRow.setState(Aspect.HOLLOW);
			}
	
			// cache aspect locally
			dependantAspectCache.addSiblingAspect(aspectName, resultAspect);
	
			return targetRow;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/** return data of row*/
	IDataContainerBean getAspectRowData(){
		return aspect.getAspectData().getRecordDataBean(index);
	}

	/**
	 * returns the <code>Aspect</code> this <code>AspectRow</code> belongs to
	 * @return IAspect the <code>Aspect</code> this <code>AspectRow</code> belongs to
	 */
	public IAspect getAspect() {
		try {
			handleAccessAspectRow();
			return aspect;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, aspect);
			return aspect;
		} 
	}

	/**
	 * Sets the given value to the attribute with given name or throws an <code>IllegalArgumentException</code>, if
	 * attributeName is no valid name for an attribute.</p>
	 * @param attributeName the name of the attribute
	 * @param value the value of the attribute as Object to set
	 */
	public void setAttributeValue(IDataContainerBean data) {
		//String attributeName,
		//Object attributeValue) {
		final String method = jARMRequest + ":setAttributeValue(IDataContainerBean)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			handleAccessAspectRow();
			recalculateTrigger = true;

			aspect.getAspectData().setValue(index, data);//attributeName, attributeValue);
			//if (key.getKeyDescriptor().getStructure().hasField(attributeName)) {
				key.takeFieldsFromRow(this);
			//}
			
			IFieldDescriptor[] fieldDescs = getDescriptor().getFieldDescriptors();
			for(int i=0;i<fieldDescs.length;++i) {
				handleDirtyState(fieldDescs[i].getName());
			}
			
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Set attribute value
	 */
	public void setAttributeValue(String name, Object value) {
		final String method = jARMRequest + ":setAttributeValue(String, Object)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try{
			//IDataContainerBean data = aspect.getAspectData().getRecordDataBean(index);
			//CAFPublicLogger.LOC_CAF.infoT("setAttributeValue name="+name+" value="+value);
			//data.setProperty(name, value);
			
			aspect.getAspectData().setValue(index, name, value);
			handleDirtyState(name);
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}

	}

	/**
	 * Sets the given value to the attribute with given index or throws an <code>IndexOutOfBoundsException</code>.
	 * @param attributeIndex the index of the attribute
	 * @param value the value of the attribute as Object to set
	 */
	public void setAttributeValue(int attributeIndex, Object attributeValue) {
		final String method = jARMRequest + ":setAttributeValue(int, Object)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2 );
		try {
			handleAccessAspectRow();
			recalculateTrigger = true;
			aspect.getAspectData().setValue(index, attributeIndex, attributeValue);
			handleDirtyState(
				getDescriptor().getFieldDescriptor(attributeIndex).getName());
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	private int getFieldIndex(String fieldName){
		IStructureDescriptor descriptor = getDescriptor(); 
		int fieldIndex = descriptor.getFieldIndex(fieldName);
		if (fieldIndex<0){
			throw new IllegalArgumentException("Field name '" + fieldName + "' not found in structure '" + descriptor.getName() + "'.");
		}
		return fieldIndex;
	}

	private void loadAttributeValue(String attributeName){
		Aspect aParentAspect = (Aspect) getAspect();
		int iOldState = aParentAspect.getState();
		try {
			aParentAspect.setState(Aspect.PROCESS_QUEUE_WAITING);
			((ServiceModule)aspect.getServiceModule()).getAspectServiceAccess().invokeOperation("loadProperty",new Object[]{attributeName}, null);
		}catch(ServiceException e){
		}finally {
			aParentAspect.setState(iOldState);
		}		
	}

	private static final int CALC_MODE_NONE = 0;
	private static final Integer ICALC_MODE_NONE = new Integer(CALC_MODE_NONE);
	private static final String SCALC_MODE_NONE = "none";
	private static final String SCALC_MODE_FALSE = "false";

	private static final int CALC_MODE_ALWAYS = 1;
	private static final Integer ICALC_MODE_ALWAYS = new Integer(CALC_MODE_ALWAYS);
	private static final String SCALC_MODE_ALWAYS = "always";

	private static final int CALC_MODE_ONCHANGE = 2;
	private static final Integer ICALC_MODE_ONCHANGE = new Integer(CALC_MODE_ONCHANGE);
	private static final String SCALC_MODE_ONCHANGE = "onchange";
	private static final String SCALC_MODE_TRUE = "true";

	private static final Map CALCULABLE;
	static {
		Map m = new HashMap(11);
		m.put("calculable=" + SCALC_MODE_NONE, ICALC_MODE_NONE);
		m.put("calculable=" + SCALC_MODE_FALSE, ICALC_MODE_NONE);
		m.put("calculable=" + SCALC_MODE_ALWAYS, ICALC_MODE_ALWAYS);
		m.put("calculable=" + SCALC_MODE_ONCHANGE, ICALC_MODE_ONCHANGE);
		m.put("calculable=" + SCALC_MODE_TRUE, ICALC_MODE_ONCHANGE);
		CALCULABLE = Collections.unmodifiableMap(m);
	}
	
	private static int getCalcMode(String attr) {
		Object o = CALCULABLE.get(attr);
		return attr == null || o == null ? CALC_MODE_NONE : ((Integer)o).intValue();
	}
	
	private boolean m_lockedForRefresh;
	/**
	 * @param attributeName
	 * @param table
	 */
	protected void refreshCalculableValues(String attributeName, IEdoTable table) {
		final String method = jARMRequest + ":refreshCalculableValues(String, IEdoTable)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			IFieldDescriptor fieldDescriptor = getDescriptor().getFieldDescriptor(attributeName); 
			if (!m_lockedForRefresh && needToRecalc(fieldDescriptor)) {
				refreshCalculableValues(fieldDescriptor);
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	protected void refreshCalculableValues(int attributeIndex, IEdoTable table) {
		final String method = jARMRequest + ":refreshCalculableValues(int, IEdoTable)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			IFieldDescriptor fieldDescriptor = getDescriptor().getFieldDescriptor(attributeIndex); 
			if (!m_lockedForRefresh && needToRecalc(fieldDescriptor)) {
				refreshCalculableValues(fieldDescriptor);
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}
	
	private boolean needToRecalc(IFieldDescriptor fd) {
		return needToRecalc(fd.getText(1));
	}

	private boolean needToRecalc(String s) {
		int iCalculableMode = getCalcMode(s);
		return (iCalculableMode == CALC_MODE_ALWAYS
				|| iCalculableMode == CALC_MODE_ONCHANGE && recalculateTrigger);	
	}
	
	private void refreshCalculableValues(IFieldDescriptor fieldDescriptor) {
		final String method = jARMRequest + ":refreshCalculableValues(IFieldDescriptor)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			if (!m_lockedForRefresh && needToRecalc(fieldDescriptor)) {
				m_lockedForRefresh = true;
				try {
					((ServiceModule)aspect.getServiceModule()).getAspectServiceAccess().recalculate(this);			
				} catch (ServiceException e) {
					// Report no exception since it is OK the "recalculate" method can be ommited from service.
				} finally {
					m_lockedForRefresh = false;
					recalculateTrigger = false;
				}
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Returns the value of the attribute with given name as Object or throws an <code>IllegalArgumentException</code>, if
	 * attributeName is no valid name for an attribute.</p>
	 * @param attributeName the name of the attribute
	 * @return Object the value of the attribute with given name as Object or throws an <code>IllegalArgumentException</code>, if
	 * attributeName is no valid name for an attribute.
	 */
	public Object getAttributeValue(String attributeName) {
		final String method = jARMRequest + ":getAttributeValue(String)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			handleAccessAspectRow();
			refreshCalculableValues(attributeName, aspect.getAspectData());

			ensureAttributeLoaded(attributeName);
	
			Object value = aspect.getAspectData().getValue(index, attributeName);
			if (value == null) {
				value =
					getDefaultValue(
						getDescriptor().getFieldDescriptor(attributeName));
			}
			return value;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Returns the value of the attribute to given index as String or throws an <code>IndexOutOfBoundsException</code>, 
	 * if attributeIndex is no valide index.
	 * @param attributeIndex the index of the attribute
	 * @return String the value of the attribute to given index as String or throws an <code>IndexOutOfBoundsException</code>, 
	 * if attributeIndex is no valide index.
	 */
	public String getAttributeAsString(int attributeIndex) {
		final String method = jARMRequest + ":getAttributeAsString(int)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			handleAccessAspectRow();
			refreshCalculableValues(attributeIndex, aspect.getAspectData());
			
			ensureAttributeLoaded(attributeIndex);
						
			//return aspect.getAspectData().getStringValue(index, attributeIndex);
			Object value = aspect.getAspectData().getValue(index, attributeIndex);
			if(value!=null) {
				return value.toString();
			}
			return null;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Returns the value of the attribute to given index as Object or throws an <code>IndexOutOfBoundsException</code>, 
	 * if attributeIndex is no valide index.</p> 
	 * @param attributeIndex the index of the attribute
	 * @return Object the value of the attribute to given index as Object or throws an <code>IndexOutOfBoundsException</code>, 
	 * if attributeIndex is no valide index.
	 */
	public Object getAttributeValue(int attributeIndex) {
		final String method = jARMRequest + ":getAttributeValue(int)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			handleAccessAspectRow();
			refreshCalculableValues(attributeIndex, aspect.getAspectData());
			
			ensureAttributeLoaded(attributeIndex);
			
			Object value = aspect.getAspectData().getValue(index, attributeIndex);
			if (value == null) {
				value =
					getDefaultValue(
						getDescriptor().getFieldDescriptor(attributeIndex));
			}
			return value;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Returns the value of the attribute with given name as String or throws an <code>IllegalArgumentException</code>, if
	 * attributeName is no valid name for an attribute.</p>
	 * 
	 * @param attributeName the name of the attribute
	 * @return the value of the attribute with given name as String or throws an <code>IllegalArgumentException</code>, if
	 * attributeName is no valid name for an attribute.
	 */
	public String getAttributeAsString(String attributeName) {
		final String method = jARMRequest + ":getAttributeAsString(String)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			handleAccessAspectRow();
			refreshCalculableValues(attributeName, aspect.getAspectData());
			if (getDescriptor().getFieldDescriptor(attributeName) == null)
				throw new IllegalArgumentException(
					"attribute with name '" + attributeName + "' doesn't exist!");
			
			ensureAttributeLoaded(attributeName);

			return aspect.getAspectData().getStringValue(index, attributeName);
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	private void ensureAttributeLoaded(String attributeName){
		ensureAttributeLoaded(getFieldIndex(attributeName));
	}

	private void ensureAttributeLoaded(int attributeIndex){
		IFieldDescriptor desc = getDescriptor().getFieldDescriptor(attributeIndex);
		if(desc instanceof TypedFieldDescriptor){
			TypedFieldDescriptor descriptor = (TypedFieldDescriptor)getDescriptor().getFieldDescriptor(attributeIndex);			
			if (descriptor.isLoadOnDemand()){			
				if (isAttributeInitial(attributeIndex)){
					loadAttributeValue(descriptor.getName());
				}				
			}
		}
		
//		loadRowDataIfNecessary();
	}
	
/* the loading of related aspects by first request was disable because bwas bug CSN 588619
	private void loadRowDataIfNecessary() {
		//load values of row if needed
		if(isNeedLoad) {
			try {
			  ServiceModule serviceModule =
				  (ServiceModule) aspect.getServiceModule();
	
			  String[] rowKeys = this.key.getFields();
		
			  ArrayList keys = new ArrayList(1);
			  keys.add(rowKeys[0]);

			  isNeedLoad = false;//make it before supplyRowWithData for avoid cicling
				
			  Collection rawResult =  serviceModule.getAspectServiceAccess().
				  readAspectObjects(aspect.getName(), keys);
		
			  Iterator it = rawResult.iterator();
			  if(it.hasNext()) {
				  setState(Aspect.PROCESS_QUEUE_WAITING);
				  supplyRowWithData((IDataContainerBean) it.next());
				  setState(Aspect.CLEAN);
			  }
			} catch(Throwable e) {
				isNeedLoad = true;
				setState(Aspect.CLEAN);
				MessageFactory.createAndRegisterMessageFromException(e, this);
			}
		}		
	}

*/
	/**
	 * state of the <code>AspectRow</code>
	 */
	private int state = Aspect.CLEAN;

	/**
	 * executes state transition of this aspect when the
	 * instance is accessed ( read or write )
	 * @param readOnly indicates, whether a read only access is done or not.
	 */
	protected void handleAccessAspectRow() {
		final String method = jARMRequest + ":handleAccessAspectRow()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			if (state == Aspect.HOLLOW || aspect.getState() == Aspect.HOLLOW) {
				if (Aspect.EXPLICIT_FLUSH) {
					logger.fatalT(
						" AspectRow is in an invalid state: You first have to call flush()");
					throw new IllegalStateException(" AspectRow is in an invalid state: You first have to call flush()");
				} else {
					// flush the queue
					 ((ServiceModule) aspect.getServiceModule()).flush();
				}
	
			}
			if (state == Aspect.INVALID || aspect.getState() == Aspect.INVALID) {
				throw new IllegalStateException(
					" AspectRow with Key: "
						+ key
						+ " of Aspect '"
						+ aspect.getName()
						+ "' is invalid: Fatal Access Error!!!");
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}
	
	/**
	 * Sets the state.
	 * @param state the state to set
	 */
	protected void setState(int state) {
		CAFPublicLogger.LOC_CAF.debugT("setState state="+state);
		this.state = state;
	}

	/**
	 * implementation of toString for test purposes only
	 */
	public String toString() {
		try {
			handleAccessAspectRow();
			String nl = System.getProperty("line.separator");
			StringBuffer buf = new StringBuffer();
			buf.append("  <AspectRow>").append(nl);
			for (int i = 0; i < size(); i++) {
				IFieldDescriptor field = getDescriptor().getFieldDescriptor(i);
				String attributeValue = getAttributeAsString(i);
				buf
					.append("     ")
					.append(field.getName())
					.append("=")
					.append(attributeValue == null ? "<null>" : attributeValue)
					.append(nl);
			}
			buf.append("  </AspectRow>").append(nl);
			return buf.toString();
		} catch (Exception e) {
			return "Error while converting AspectRow to String. Super.toString() is: " + super.toString();
		}
	}

	private HashMap m_calcFields = new HashMap();
	private boolean needToChangeDirty(String attributeName) {
		Boolean field = (Boolean) m_calcFields.get(attributeName);
		if (null == field) {
			IFieldDescriptor fieldDescriptor = getDescriptor().getFieldDescriptor(attributeName);	
			field = new Boolean(!needToRecalc(fieldDescriptor));
			m_calcFields.put(attributeName, field);
		}
		return (null == field)? false : field.booleanValue();
	}

	/**
	 * helper method for dirty handling of an AspectRow. Dirty handling is not done in state <code>PROCESS_QUEUE_WAITING</code>,
	 * cause in this state data copies from and to Edo tables are done
	 */
	void handleDirtyState(String fieldName) {
		if("key".equals(fieldName) &&
			getDescriptor().getFieldIndex(fieldName) == -1) {
			if(getDescriptor().size()>0) {
				IFieldDescriptor fieldDescriptor = getDescriptor().getFieldDescriptor(0);
				if(fieldDescriptor!=null) {
					fieldName = fieldDescriptor.getName();
				}
			}
		}
					
		if (aspect.getState() == Aspect.PROCESS_QUEUE_WAITING
			|| state == Aspect.PROCESS_QUEUE_WAITING
			|| !needToChangeDirty(fieldName))
			// nothing to do
			return;
		setState(Aspect.DIRTY);
		aspect.registerUpdate(key, fieldName);
		
		AspectRow sourceRow = this.aspect.getSourceAspectRowOfCreatingRelation();
		if(sourceRow!=null) {
			sourceRow.handleDirtyState("key");
		}
	}

	/**
	 * returns <code>null</code> or the appropriate object of type ICMIModelClass according
	 * to the relation role in <code>rolename</code>.
	 * The rolename corresponds to the <Col> relation name of the aspect wrapped by
	 * this adapter model class.
	 * If there is no relation with an appropriate rolename, an 
	 * <code>java.lang.IllegalArgumentException</code> is thrown.
	 */
	public ICMIModelClass getRelatedModelObject(String rolename) {
		return (ICMIModelClass) getRelatedAspectRow(rolename);
	}

	/**
	 * returns the appropriate collection of objects of type ICMIModelClass
	 * according to the relation role in <code>rolename</code>,
	 * which must have the cardinality * or 1..*.<p>
	 * The collection should be immutable.<p>
	 * If the role is of cardinality 0..*, the collection is empty.
	 * The rolename corresponds to the <Col> relation name of the aspect wrapped by
	 * this adapter model class.
	 * If there is no relation with an appropriate rolename, an 
	 * <code>IllegalArgumentException</code> is thrown.<p>
	 */
	public Collection getRelatedModelObjects(String rolename) {
		return (Collection) getRelatedAspect(rolename);
	}

	private final DependantAspectCache dependantAspectCache =
		new DependantAspectCache();

	/**
	 * the index of this <code>AspectRow</code> in the List of the associated <code>Aspect</code>
	 */
	private int index;

	/**
	 * Returns the index.
	 * @return int
	 */
	int getIndex() {
		return index;
	}

	/**
	 * First step of invalidation: remove any data cached in this aspect row
	 * @todo check why two phases are needed
	 */
	protected void invalidateInternal() {
		if (state == Aspect.INVALID)
			return;

		setState(Aspect.INVALID);

		((ServiceModule) aspect.getServiceModule()).unregisterAspectRowKey(
			aspect,
			key);

		dependantAspectCache.invalidate();
	}

	/**
	 * helper method, which sets the key fields in AspectRow from
	 * given <code>Key</code> object
	 */
	protected void setKeyFields(Key newKey) {
		final String method = jARMRequest + ":setKeyFields(Key)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			if (newKey.isLocalKey()) {
				if (!key.isLocalKey()) {
					throw new RuntimeException("Initialized key cannot be converted to local one.");
				}
			} else {
				IStructureDescriptor structureDescriptor =
					aspect.getDescriptor().getKeyDescriptor().getStructure();
				int noOfFields = structureDescriptor.size();
				String[] keyFields = newKey.getKeyFields();
				for (int i = 0; i < noOfFields && i < keyFields.length; i++) {
					String fieldName =
						structureDescriptor.getFieldDescriptor(i).getName();
					// setAttributeAsString( fieldName, keyFields[i] );
					aspect.getAspectData().setStringValue(
						index,
						fieldName,
						keyFields[i]);
				}
				/* C5401200: Add synchroniation of new key and ond one. */
				key.setKeyFields(keyFields);
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Promote all SHARED_PROMOTABLE locks to EXCLUSIVE locks. </p>
	 * 
	 * Lock Mode Promotion is processed in the queue as well, therefore the result of 
	 * the lock promotion is only available after flushing the queue.</p>
	 * 
	 * @todo how to get a lock result?
	 */
	public void promoteLock() {
		//TODO locking?
		/**
		handleAccessAspectRow();
		ISrvMgrLock lockCall = ((ServiceModule)aspect.getServiceModule()).getSrvMgrServiceModule().createLock(aspect.getName());
		// copy keys to inrecords Keys table
		GenericClientUtils.copyFromKeyToTable(key, lockCall.getInKeys(), 0);
		lockCall.setLockMode(ISrvMgrLock.EXCLUSIVE);
		// register and execute call
		((ServiceModule)aspect.getServiceModule()).registerSrvMgrCallObject( lockCall, aspect );**/
	}

	/**
	 * Locks this <code>AspectRow</code> dependent of given parameter lockMode and refreshes it after lock
	 * is received. If <pre>lockMode == LockMode.NONE</pre> nothing is done.
	 * @param lockMode the lock mode for this <code>AspectRow</code>
	 */
	public void lock(LockStrategy lockMode) {
		try {
			handleAccessAspectRow();
			if (lockMode == LockStrategy.SHARED_READ_ONLY)
				return;
			aspect.lockAndRefresh(this, lockMode);
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this);
		} 
	}

	/**
	 * Release any lock previously acquired for this row
	 */
	public void unlock() {
		//TODO handle locking?
		/**handleAccessAspectRow();
		ISrvMgrUnlock unLockCall = ((ServiceModule)aspect.getServiceModule()).getSrvMgrServiceModule().createUnlock(aspect.getName());
		// copy keys to inrecords Keys table
		GenericClientUtils.copyFromKeyToTable(key, unLockCall.getInKeys(), 0);
		// register and execute call
		((ServiceModule)aspect.getServiceModule()).registerSrvMgrCallObject( unLockCall, aspect );
		**/
	}

	/**
	 * @see com.sap.tc.col.client.generic.core.ISrvMgrCaller#onCallsProcessed(ISrvMgrCall[])
	 */
	public void onCallsProcessed(ISrvMgrCall[] calls) {
		// @todo remember executed calls and/or extract messages
	}

	/**
	 * Update index. Only used by owning aspect to renumber rows after deletion of one or more rows.
	 * @param i new index of this row in the edo table of the owning aspect.
	 */
	void setIndex(int i) {
		index = i;
	}

	/**
	 * Returns <code>true</code> if this <code>AspectRow</code> is valid, otherwise <code>false</code>. If
	 * this <code>AspectRow</code> is not valid, accessing the AspectRow leads to an IllegalStateException.</p>
	 */
	public boolean isValid() {
		return (state != Aspect.INVALID);
	}

	/**
	 * returns the name of this <code>Action</code>
	 */
	public String getName() {
		return aspect.getDescriptor().getName();
	}

	public String getRelativeKeyUrl() {
		//TODO figure this out
		/**
		if ( key.isLocalKey() )
		  throw new IllegalStateException("can't determine relative key url for a local key");
		
		return
		  ((ServiceModule)aspect.getServiceModule()).getSrvMgrServiceModule().getServiceManager()
		    .getRelativeAspectRowKey(aspect.getDescriptor(), aspect.getAspectData(), index);
		**/
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getMessages()
	 */
	public IMessageList getMessages() {
		// TODO Auto-generated method stub
		return null;
	}

	public IAspect getRelatedAspect(
		String arg0,
		LockStrategy arg1,
		SortingCriteria arg2) {
			return getRelatedAspect(arg0, arg1);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IStructure#isAttributeInitial(int)
	 */
	public boolean isAttributeInitial(int attributeIndex) {		
		return !loadedAttributes.get(attributeIndex);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IStructure#isAttributeInitial(java.lang.String)
	 */
	public boolean isAttributeInitial(String attributeName) {	
		int index = getFieldIndex(attributeName);
		return isAttributeInitial(index);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#hasExclusiveLock()
	 */
	public boolean hasExclusiveLock() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#hasNoLock()
	 */
	public boolean hasNoLock() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#hasSharedLock()
	 */
	public boolean hasSharedLock() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#hasSharedPromotableLock()
	 */
	public boolean hasSharedPromotableLock() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#isDirty()
	 */
	public boolean isDirty() {
		return aspect.getState() == Aspect.DIRTY || aspect.getState() == Aspect.DIRTY_PENDING;
	}
	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IAspectRow#getLockState()
	 */
	public ILockState getLockState() {
		// TODO Auto-generated method stub
		return null;
	}
	
	public int hashCode() {
		// Be warned that the hash code should be set to 0 if uniqueness of keys is not the case.
		return String.valueOf(getKey()).hashCode();
	}
	
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o instanceof AspectRow) {
			AspectRow ar = (AspectRow) o;
			IKey arKey = ar.getKey();
			if(arKey.getFields()!=null && arKey.getFields().length == 0) {
				return arKey.equals(getKey())
					&& ar.getAspect() == getAspect()
					&& isAttributesEqual(ar);
			} else {
				return arKey.equals(getKey())
					&& ar.getAspect() == getAspect();
					// The case was commented out for performance reason. It is most likely that rows are equal 
					// if they belong to the same aspect and have identical keys.
					//&& isAttributesEqual(ar);
			} 
		}
		return false;
	}
	
	private boolean isAttributesEqual(AspectRow ar) {
		IStructureDescriptor arDesc = ar.getDescriptor();
		IStructureDescriptor thisDesc = getDescriptor();
		int size = thisDesc.size();
		if (arDesc.size() == size) {
			  for (int i = 0; i < size; i++) {
				IFieldDescriptor fd1 = thisDesc.getFieldDescriptor(i);
			  	IFieldDescriptor fd2 = arDesc.getFieldDescriptor(i);
			  	String name1 = fd1.getName();
				String name2 = fd2.getName();
			  	if (name1.equals(name2)) {
					Object a1 = getAttributeValue(name1);  											  	
					Object a2 = ar.getAttributeValue(name1);
					if((a1==null && a2!=null) || (a1!=null && !a1.equals(a2))) {
						return false;
					}
			  	} else {
					return false;
			  	}
			  }
		} else {
			return false;
		}
		return true;
	}
	
	/**
	 * Calculate reference field on IDataContainerBean 
	 */
	protected void calculateReferences(){
		try{		
			IRelationDescriptor[] descrs = this.aspect.getDescriptor().getRelationDescriptors();
			for(int i = 0 ; i < descrs.length; i++){
				String relationName = descrs[i].getName();
				Aspect relAspect = (Aspect)this.getRelatedFromCache(relationName, LockStrategy.SHARED_READ_ONLY);
				if(relAspect != null){
					String isComplex = relAspect.getDescriptor().
						getAttributeStringValue("complex_attribute");
					String relationAttribute = Util.getSourceRelationAttribute(descrs[i]);
											
					if("true".equals(isComplex) 
						&& !descrs[i].getAttributeTargetCardinality().isMultiple()) { //process single complex attribute
						IEdoTableEx table = relAspect.getAspectData();
						if(table!=null && table.getRecordCount()>0) {
							this.getAspectRowData().setProperty(relationAttribute,
								table.getRecordDataBean(0));
						} else {
							this.getAspectRowData().setProperty(relationAttribute,
								null);	
						}
													
						if(aspect.getState()== Aspect.CLEAN &&
							relAspect.getState()== Aspect.DIRTY){
							aspect.setState(Aspect.DIRTY); 
						}
					} else {
						if(descrs[i].getAttributeTargetCardinality().isMultiple()) {
							if("true".equals(isComplex)) {
								Collection complexAttrData = new ArrayList();
								
								IEdoTableEx table = relAspect.getAspectData();
								int size = table.getRecordCount();
								for(int j=0;j<size;++j) {
									Object val = table.getRecordDataBean(j);
									if(val!=null) {
										complexAttrData.add(val);
									}
								}
															
								this.getAspectRowData().setProperty(relationAttribute, complexAttrData);
							} else if("true".equals(relAspect.getDescriptor().
								getAttributeStringValue("collection_support"))) {
								Collection values = relAspect.getCollectionValues("value");
								this.getAspectRowData().setProperty(relationAttribute, values);
							} else {
								Collection keys = relAspect.getCollectionStringKeys();
								this.getAspectRowData().setProperty(relationAttribute, keys);
							}
						} else {
							Collection keys = relAspect.getCollectionStringKeys();
							if((keys != null) && (!keys.isEmpty()))
								this.getAspectRowData().setProperty(relationAttribute, keys.iterator().next());
							else
								this.getAspectRowData().setProperty(relationAttribute, null);
						}
					
						if(aspect.getState()== Aspect.CLEAN){
							aspect.setState(Aspect.DIRTY); 
						}
					}
				}
			}
		}catch(Exception e){
			logger.catching(e);
		}
		
	}
	

}
