/* Generated by Together */

package com.sap.caf.rt.ui.cool.generic;

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;


import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.logging.Location;

/**
 * realizes a cache for <code>Aspect</code>s.<p>
 * 
 * The class contains a root object of type <code>ICacheRootObject</code>.
 * It is created and referenced from <code>ServiceModule</code> by its root object.<p>
 * 
 * The <code>AspectCache</code> offers methods to add <code>Aspect</code>s, clear the cache or to get
 * information about the state of the cache.
 * 
 * @author Helmut Mueller
 */
class AspectCache {

  /** Logging properites for this class */
  private static final String APPLICATION	= AspectCache.class.getName();
  private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
  private static final Location logger = Location.getLocation(APPLICATION);
 
  /**
   * constructor
   */
  protected AspectCache( ICacheRootObject cacheRootObject ) {
    this.cacheRootObject = cacheRootObject;
 	  this.aspects = new ArrayList();
  }
  
  /**
   * clears the <code>AspectCache</code>, means remove all elements
   */
  protected void clear() { 
    aspects.clear();
  }

  /**
   * inserts an <code>Aspect</code> to the cache and binds this <code>AspectCache</code> to
   * the inserted <code>Aspect</code>
   * @param aspect an <code>Aspect</code> to insert
   */
  protected void add(IAspect aspect) {
    if ( !aspects.contains(aspect) ) {
      aspects.add( aspect );
      ((Aspect)aspect).bindAspectCache(this);
    }
  }
  
  /**
   * checks, whether this <code>AspectCache</code> the given <code>Aspect</code>
   * @param aspect the <code>Aspect</code> to check
   * @return boolean <code>true</code>, if this <code>AspectCache</code> contains the given <code>Aspect</code>
   */
  protected boolean contains(IAspect aspect) {
    return aspects.contains(aspect);
  }
  
  /**
   * returns an <code>Iterator</code> for all <code>Aspect</code>s in the cache
   * @return Iterator an <code>Iterator</code> for all <code>Aspect</code>s in the cache
   */
  protected Iterator iterator() {
    return aspects.iterator();
  }
  
  private boolean dirty = false;
  
  /**
   * checks, whether this <code>AspectCache</code> is DIRTY, means contains an DIRTY <code>Aspect</code>.<p>
   * @return boolean <code>true</code>, if this <code>AspectCache</code> contains a DIRTY <code>Aspect</code>
   */
  boolean isDirty() {
    return dirty;
  }
  /**
   * sets cache to dirty if dirty is <code>true</code>, otherwise reset dirty flag
   */
  void setDirty( boolean dirty ) {
    this.dirty = dirty;
  }

  /**
   * the root object of this <code>AspectCache</code>
   * @clientCardinality 1
   * @supplierCardinality 1
   * @link aggregation 
   */
  private ICacheRootObject cacheRootObject;  

  /**
   * the list of <code>Aspect</code>s of this <code>AspectCache</code>
   * @link aggregation
   * @associates <{Aspect}>
   * @supplierRole cachedAspects
   * @supplierCardinality 0..*
   * @clientCardinality 1
   * @undirected
   */
  private List aspects;

  /**
   * Returns the root object of this <code>AspectCache</code>
   * @return ICacheRootObject the root object of this <code>AspectCache</code>
   */
  protected ICacheRootObject getCacheRootObject() {
    return cacheRootObject;
  }

}
