package com.sap.caf.rt.ui.cool.generic;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.sap.tc.cmi.model.ICMIGenericModelClass;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.cmi.util.ICMIModificationCount;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.logging.Location;

/**
 * Base class for all &lt;cool&gt; ICMIGenericModelClass implementations.</p>
 * 
 * Provides default implementations for all attribute and relation accessor methods 
 * defined by ICMIGenericModelClass. The implementations throw either an IllegalArgumentException 
 * or an UnsupportedOperationException. See method documentatoin for details.</p> 
 * 
 * Subclasses only have to override/extend those methods they are interested in. Eg. Structure 
 * doesn't support relations, Query has no attributes etc.</p>
 * 
 * @author Helmut Mueller, Stephan Ritter
 */
public abstract class AbstractModelClass
	implements ICMIGenericModelClass, ICMIModificationCount {

	/** Logging properites common for whole DC */
	public static final String jARMReqPrefix = "XAP:COOL:";
	/** Logging properites for this class */
	private static final String APPLICATION	= AbstractModelClass.class.getName();
	private static final String jARMRequest = jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);
	
	long modCount;

	public AbstractModelClass() {
		modCount = 0L;
	}

	/**
	 * returns the attribute with the given <code>name</code> as Object.
	 * cause not every implementation has attributes, the implementation
	 * of the base class throws an IllegalArgumentException
	 */
	public Object getAttributeValue(String name) {
		throw new java.lang.IllegalArgumentException();
	}

	/**
	 * sets the attribute to given <code>value</code>.
	 * cause not every implementation has attributes, the implementation
	 * of the base class throws an IllegalArgumentException
	 */
	public void setAttributeValue(String name, Object value) {
		throw new java.lang.IllegalArgumentException();
	}

	/**
	 * returns <code>null</code> or the appropriate object of type ICMIModelClass according
	 * to the relation role in <code>rolename</code>, which must have the cardinality 1 or 0..1.<p>
	 * If the role is of cardinality 0..1,
	 * <code>null</code> can be returned.<p>
	 * If there is no relation with an appropriate rolename, an 
	 * <code>java.lang.IllegalArgumentException</code> is thrown.
	 * This is the implementation of this base class.
	 */
	public ICMIModelClass getRelatedModelObject(String rolename) {
		throw new java.lang.IllegalArgumentException();
	}

	/**
	 * sets the relation role <code>rolename</code> of an x:0..1 or x:1 relation to object o of type
	 * ICMIModelClass.<p>
	 * If o is <code>null</code> and the cardinality of the relation role is 1,
	 * a <code>java.lang.NullPointerException</code> exception is thrown.<p>
	 * If <code>this</code> has no relation role with the given <code>rolename</code>,
	 * an <code>java.lang.IllegalArgumentException</code> is thrown.<p>
	 * If the model class or the model are read only, or if the model implementation doesn't
	 * support this method, an <code>java.lang.UnsupportedOperationException</code> is thrown.<p>
	 * If the method throws an exception, no changes are made of course.
	 * This is the implementation of this base class.
	 */
	public void setRelatedModelObject(String rolename, ICMIModelClass o) {
		throw new java.lang.UnsupportedOperationException();
	}

	/**
	 * returns the appropriate collection of objects of type ICMIModelClass
	 * according to the relation role in <code>rolename</code>,
	 * which must have the cardinality * or 1..*.<p>
	 * The collection should be immutable.<p>
	 * If the role is of cardinality 0..*, the collection could be empty, but not
	 * <code>null</code>.<p>
	 * If there is no relation with an appropriate rolename, an 
	 * <code>java.lang.IllegalArgumentException</code> is thrown.<p>
	 * If the method throws an exception, no changes are made of course.
	 * This is the implementation of this base class.
	 */
	public Collection getRelatedModelObjects(String rolename) {
		throw new java.lang.IllegalArgumentException();
	}

	/**
	 * sets the relation role <code>rolename</code> of an x:* or x:1..* relation to the Collection
	 * <code>col</code>, which contains exclusively objects of type ICMIModelClass.<p>
	 * If <code>col</code> is <code>null</code>,
	 * a <code>java.lang.NullPointerException</code> exception is thrown.<p>
	 * If <code>col</code> is empty and the cardinality of the relation role is 1..*,
	 * a <code>java.lang.NullPointerException</code> exception is thrown.<p>
	 * If <code>this</code> has no relation role with the given <code>rolename</code>,
	 * a <code>java.lang.IllegalArgumentException</code> is thrown.<p>
	 * If the model class or the model are read only, or if the model implementation doesn't
	 * support this method, an <code>java.lang.UnsupportedOperationException</code> is thrown.<p>
	 * If the method throws an exception, no changes are made of course.
	 */
	public void setRelatedModelObjects(String rolename, Collection col) {
		throw new java.lang.UnsupportedOperationException();
	}

	/**
	 * adds <code>o</code> to the relation role <code>rolename</code> according to the <code>add</code>
	 * method in the <code>java.util.Collection</code> interface.<p>
	 * If <code>o</code> is <code>null</code>, a <code>java.lang.NullPointerException</code> exception is thrown
	 * and no changes are made of course.<p>
	 * If <code>this</code> has no relation role with the given <code>rolename</code> and cardinality 
	 * * or 1..*, a <code>java.lang.IllegalArgumentException</code> is thrown.<p>
	 * If the model class or the model are read only, or if the model implementation doesn't
	 * support this method, an <code>java.lang.UnsupportedOperationException</code> is thrown.<p>
	 * If the method throws an exception, no changes are made of course.
	 */
	public boolean addRelatedModelObject(String rolename, ICMIModelClass o) {
		throw new java.lang.UnsupportedOperationException();
	}

	/**
	 * removes <code>o</code> from the relation role <code>rolename</code> according to the
	 * <code>remove</code> method in the <code>java.util.Collection</code> interface.<p>
	 * If <code>o</code> is <code>null</code> or <code>o</code> was not in the collection,
	 * the method silently returns.<p>
	 * If <code>o</code> is the last element in the relation role, and the cardinality of the role
	 * is 1..*, a <code>java.lang.IllegalArgumentException</code> is thrown.<p>
	 * If <code>this</code> has no relation role with the given <code>rolename</code> and cardinality 
	 * * or 1..*, a <code>java.lang.IllegalArgumentException</code> is thrown.<p>
	 * If the model class or the model are read only, or if the model implementation doesn't
	 * support this method, an <code>java.lang.UnsupportedOperationException</code> is thrown.<p>
	 * If the method throws an exception, no changes are made of course.
	 */
	public boolean removeRelatedModelObject(
		String rolename,
		ICMIModelClass o) {
		throw new java.lang.UnsupportedOperationException();
	}

	/**
	 * Map of default values for types mapped by their type name (String) 
	 */
	private static final Map defaultsByType = new HashMap();
	static {
		defaultsByType.put(IFieldDescriptor.BOOLEAN, Boolean.FALSE);
		defaultsByType.put(IFieldDescriptor.DOUBLE, new Double(0.0));
		defaultsByType.put(IFieldDescriptor.INTEGER, new Integer(0));
		defaultsByType.put(IFieldDescriptor.DECIMAL, new BigDecimal(0));
	}

	/**
	 * Return the default value for the given field depending on its type.
	 * The value is returned as an object. For the types BOOLEAN, DOUBLE and 
	 * INTEGER the default value is the Java defined default value of the primitive 
	 * type, but wrapped as an Object. </p>
	 * Public get methods in subclasses call this method to convert internal null 
	 * values (initial values) into more suitable default values.</p>
	 */
	protected static Object getDefaultValue(IFieldDescriptor fieldDescriptor) {
		return defaultsByType.get(fieldDescriptor.getType());
	}

	public long modCount() {
		return modCount;
	}

	protected void incrementModCount()
	{
		if(modCount < 0x7fffffffffffffffL)
			modCount++;
		else
			modCount = 0L;
	}
}
