package com.sapportals.portal.security.usermanagement;

/**
 * Title:        UserManagementRuntimeException
 * Description:  Runtime exception for errors in usermanagement
 * Copyright:    Copyright (c) 2001
 * Company:      SAP Portals
 * @version 1.0
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 */

public class UserManagementRuntimeException extends RuntimeException
{
  // inner exception
  protected Throwable rootCause = null;

  /**
   *  Default constructor
   */
  public UserManagementRuntimeException()
  {
    super();
  }

  /**
   *  Constructs a runtime exception with the specified message
   */
  public UserManagementRuntimeException(String msg)
  {
    super(msg);
  }

  /**
   *  Constructs a runtime exception with the specified message and the specified
   *  Throwable as root cause
   */
  public UserManagementRuntimeException(String msg, Throwable rootCause)
  {
    super(msg);
    this.rootCause = rootCause;
  }

  /**
   *  Set the specified Throwable as root cause for this exception
   */
  public void setRootCause(Throwable newRootCause)
  {
    this.rootCause = newRootCause;
  }

  /**
   *  Get the root cause for this exception
   */
  public Throwable getRootCause ()
  {
    return this.rootCause;
  }
}