package com.sapportals.portal.security.usermanagement;

/**
 *               must implement a suitable algorithm to find usermapping data for
 *               a principal. This algorithm only implements the search for mapping data
 *               from a principal, i.e. the order in which the mapping data can be inherited.
 *
 * Copyright (c) SAP Portals Europe GmbH 2001
 * @author Steffen Huester
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 */

public interface IUserMappingLookup
{
  /**
   *  Lookup usermapping data for the given principal and system name. This method
   *  does no technical lookup on a data store but only determines the principal that
   *  stores the required mapping data
   *
   *  @param the principal to look mapping data for
   *  @param the logical (unique) system name for which the mapping data is searched
   *
   *  @return the principal who stores the required mapping data or null if none is found
   */
  public IUMPrincipal findMapping (IUMPrincipal principal, String systemId);
}