package com.sapportals.portal.security.usermanagement;

import java.util.Collection;
import java.util.Map;

/**
 * This factory class provides functionality to get User objects by providing required info.
 *
 * @author Alexander Primbs
 * @version $Revision: #4 $ <BR>
 * @deprecated <I>This interface has been
 * replaced by interface <code>com.sap.security.api.IUserFactory</code> which is 
 * part of the User Management Engine(UME) APIs.</I>
 */

public interface IUserFactory
{

        /**
         * Returns a user object for an existing user.
         *
         * @param	uid		id of the user
         * @return	IUser	a user object implementing IUser
         * <code>null</code> if no uid is available
         * @exception		UserManagementException
         */
        public IUser getUser(String uid)
                throws UserManagementException;

        /**
         * Returns a user object depending on mode.
         *
         * @param	uid		id of the user
         * @param	mode    following modes are allowed:
         *   FULL   : all the data necessary for this user object is contained in this object. The object
         *            representing the IUser interface contains all information fetched from the persistence
         *            layer
         *   MINIMUM: it is checked that the IUser object exists in the persistence layer and only contains
         *            minimum set of data. If additional data is needed which is transparent to the application
         *            there is a round trip necessary to fetch additional data.
         *   TRUSTED: the user object returned is not guaranteed to exist on the persistence layer
         *            If this option is chosen, it is not checked if the user object exists in the data store.
         *            This means, you will get an IUser object which does not belong to your data store population.
         *            For such an object it only makes sense to call following interfaces of IUser method:
         *            @link IUMPrincipal#equals(IUMPrincipal principal)
         *            @link IUMPrincipal#getType();
         *            All other methods will return a @link UserManagementRuntimeException
         *
         *
         * @return	IUser	a user object implementing IUser
         *
         * @exception		UserManagementException
         * @deprecated
         */
        public IUser getUser(String uid, int mode)
                throws UserManagementException;

        public static final int FULL     = 0;
        public static final int MINIMUM  = 1;
        public static final int TRUSTED  = 2;
        /**
         *  Returns a IModifyUser object to be used to modify a user.
         * <p>
         * Use method setValue() to modify attributes of this user
         * Call method save of IModifyUser to update the user information
         *
         * @param  uid		uid of User that should be modified
         * @param  requestUser  IUser object of user who is requesting the
         *                      modifiable object
         * @return	IModifyUser to modify the user
         * <code>null</code> if no user object is available
         * @exception  UserManagementException
         */
        public IModifyUser getModifyUser(String uid, IUser requestUser)
                throws UserManagementException;

        /**
         * Returns a IModifyUser object to be used to modify a user.
         * <p>
         * Use method setValue() to modify attributes of this user
         * Call method save of IModifyUser to update the user information
         *
         * @param  uid	user object that should be modified
         * @param  requestUser  IUser object of user who is requesting the
         *                      modifiable object
         * @return      IModifyUser to modify the user
         * <code>null</code> if no user object is available
         * @exception   UserManagementException
         */
        public IModifyUser getModifyUser(IUser user, IUser requestUser)
                throws UserManagementException;

        /**
         *  Finds all groups matching specific group information. <p>
         *
         *  To set the search criteria, create a new ISearchGroup and set
         *  the respective group information.
         *
         * @param  searchdata		ISearchGroup
         * @param	maxcount		maximal number of entries (0 for all)
         * @return	Array of groups
         * <code>null</code> if no group objects are available
         * @exception  UserManagementException
         */
        public String[] findGroups(ISearchGroup searchdata, int maxcount)
                throws UserManagementException;


        /**
         *  Finds all groups matching specific group information. <p>
         *
         *  To set the search criteria, create a new ISearchGroup and set
         *  the respective group information.
         *
         * @param  searchdata		ISearchGroup
         * @param	maxcount		maximal number of entries (0 for all)
         * @return	Collection of partly populated group objects IGroup
         * <code>null</code> if no group objects are available
         * @exception  UserManagementException
         */
        public Collection find(ISearchGroup searchdata, int maxcount)
                throws UserManagementException;




        /**
         *  Finds all users matching specific user information. <p>
         *
         *  To set the search criteria, create a new ISearchUser and set
         *  the respective user information.
         *
         * @param  searchdata		ISearchUser
         * @param	maxcount		maximal number of entries (0 for all)
         * @return	Array of users
         * <code>null</code> if no user objects are available
         * @exception  UserManagementException
         */
        public String[] findUsers(ISearchUser searchdata, int maxcount)
                throws UserManagementException;


        /**
         *  Finds all users matching specific user information. <p>
         *
         *  To set the search criteria, create a new ISearchUser and set
         *  the respective user information.
         *
         * @param  searchdata		ISearchUser
         * @param	maxcount		maximal number of entries (0 for all)
         * @return	Collection of partly populated IUser objects
         * <code>null</code> if no user objects are available
         * @exception  UserManagementException
         */
        public Collection find(ISearchUser searchdata, int maxcount)
                throws UserManagementException;




        /**
         *  Returns an ISearchUser object to be used to specify query attributes
         * <p>
         * ISearchUser only contains attributes which will be queried
         *
         *@return     ISearchUser without attributes
         * <code>null</code> if no user object is available
         *@exception  UserManagementException
         *@exception  FeatureNotAvailableException
         */
        public ISearchUser getSearchUser()
                throws UserManagementException;

        /**
         * Creates new user on the persistence repository.
         *
         * @param		userId		 user id of the user to create
         * @param		password	 the user's password
         * @param		initialAttrbutes Map of initial attributes to set.
         *                      LDAP requires additional attributes to create a user entry.
         *                      These attributes have to be set in advance. The map keys are logical attributes
         *                      (e.g lastname).
         * @exception	UserManagementException
         */
        public void createUser(String userId, String password, Map attributes)
                throws UserManagementException;

        /**
         * Deletes the user
         *
         * @param		user		the user object
         * @exception	UserManagementException
        public void deleteUser(IUser user)
                throws UserManagementException;
     */
        /**
         * Retrieves usermapping information in a result list. This method
         * should be used for a fast search for usermapping entries for several
         * users and systems. The result is an array of {@link IUserMappingEntry}, which only
         * contains the assignment of portal users to systems and mapped users.
         *
         * This method does not retrieve any logon data. Applications that need to logon to a backend
         * system should use {@link ILogonDataBroker} instead.
         *
         * @param userFilter the search result will be filtered for the (portal) user-ids in this array;
         *    if null, the usermapping for all users will be retrieved
         * @param systemFilter the search result will be filtered for the sytem names in this array;
         *    if null, the usermapping for all systems will be retrieved
         *
         * @return an array of {@link IUserMappingEntry} objects containing
         * the relationship of portal users and backend users for each system
         *
         * @throws UserManagementException if any error accessing the user repository occured
         * @throws SearchResultSizeLimitExceededException if the search result would be too large; callers should use more restrictive
         *    filter arguments to handle this exception
         */
        public IUserMappingEntry[] findUserMapping(String [] userFilter, String [] systemFilter)
                throws UserManagementException;


        /**
         *  Delete all usermapping entries with the specified system id. This method can be used
         *  to ensure data consistency of the usermappings if a datasource gets deleted.
         *
         *  @param the system id for which all usermapping entries will be deleted
         *  @param  requestUser  IUser object of user who is requesting this method;
         *                       this user must be authenticated and admin
         *
         *  @return the number of deleted entries
         *
         *  @throws UserManagementException if an error occurs during deletion
         */
        public int deleteUserMapping(String systemId, IUser requestUser) throws UserManagementException;

        /**
         * Gets the user object of the new user management interface UME
         */
         public com.sap.security.api.IUser getUMEUser(com.sapportals.portal.security.usermanagement.IUser ep5User)
            throws com.sap.security.api.NoSuchUserException;

        /**
         * Gets the EP5.0 user object of the new user management interface UME
         */
         public com.sapportals.portal.security.usermanagement.IUser getEP5User(com.sap.security.api.IUser umeUser)
                    throws UserManagementException;
                    
		/**
		 * Gets an EP5 IUMEPrincipal object from a umeUniqueId. This method is equivalent to
		 * to following call of method:
		 *     public IPrincipal getPrincipal(String uniqueId) throws UMException;
		 * of interface com.sap.security.api.IPrincipalFactory 
		 * 
		 * @param umeUnique specifies a uniqueId of UME IPrincipal 
		 * @return IUMEPrincipal which represents the UME object for EP5 usage
		 */
		 public com.sapportals.portal.security.usermanagement.IUMEPrincipal getEP5Principal(String umeUniqueId)
			throws com.sap.security.api.NoSuchPrincipalException, UserManagementException;
			
		/****
		* This method checks if 
		* @param idString
		* represents a valid UME Principal. 
		* @return <code>true</code> if idString represents a well defined UME String
		* <code>false</code> in case otherwise or if idString is null
		* @throws UserManagementException in case an error occurs
		* <p>Note: This method does not check the existence of @param idString.
		* It is simply checked if the String represents a uniqueID according to UME
		* conventions.
		**/
		public boolean isUMEUniqueId(String idString) throws UserManagementException;			
                    
}
