package com.sapportals.portal.security.usermanagement;

import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

/**
 * This class provides functionality to read user information of registered user.
 *
 * @author  Alexander Primbs
 * @version $Revision: #4 $ <BR>
 * @deprecated <I>This interface has been
 * replaced by interface <code>com.sap.security.api.IUser</code> which is 
 * part of the User Management Engine(UME) APIs.</I>
 *
 */

public interface IUser extends  java.io.Serializable, java.security.Principal,
                                com.sapportals.portal.security.usermanagement.IUMPrincipal
{
    public static final String    FIRSTNAME       = "firstname";
    public static final String    LASTNAME        = "lastname";

    public static final String    SALUTATION      = "salutation";
    // the user's honoric prefix, e.g. Dr.
    public static final String    TITLE           = "title";
    public static final String    COMPANY         = "company";
    public static final String    DEPARTMENT      = "department";
    // the user's current position in the company, e.g. Architect
    public static final String    POSITION        = "position";

    // session information
    public static final String    PREFERREDLANGUAGE = "preferredlanguage";
    //public static final String    LOGONDEVICE     = "logondevice";
    public static final String    CURRENCY        = "currency";

    // Communications
    public static final String    EMAIL           = "email";
    public static final String    TELEPHONE       = "telephone";
    public static final String    MOBILE          = "mobile";
    public static final String    FAX             = "fax";

    // address
    public static final String    STREETADDRESS   = "streetaddress";
    public static final String    CITY            = "city";
    public static final String    ZIP             = "zip";
    public static final String    POBOX           = "pobox";
    public static final String    COUNTRY         = "country";
    public static final String    STATE           = "state";

    public static final String    DATEFORMAT      = "dateformat";
    public static final String    LOCALE          = "locale";
    public static final String    TIMEZONE        = "timezone";

    public static final String    ACCESSIBILITYLEVEL = "accessibilitylevel";
    public static final int       DEFAULT_ACCESSIBILITY_LEVEL = 0;
    public final static String    ANONYMOUS = "anonymous";

    /**
     * Gets the user's first name
     * @return	 the user's first name
     * @deprecated New applications should use UME interface com.sap.security.api .
     */
    public String getFirstName();

    /**
     * Gets the user's last name
     * @return	 the user's last name
     */
    public String getLastName();

    /**
     * Gets the user's salutation (e.g. 'mr')
     * @return	 the user's salutation
     */
    public String getSalutation();

    /**
     * Gets the user's title (e.g. Dr.)
     * @return	 the user's title
     */
    public String getTitle();

    /**
     * Gets the user's preferred language
     * @return	 the user's preferred language or <code>null</code>
     */
    public String getPreferredLanguage();

    /**
     * Gets the user's currency
     * @return	 the user's currency
     */
    public String getCurrency();

    /*** COMMUNICATIONS ***/

    /**
     * Gets the user's email address
     * @return	 the user's email address
     */
    public String[] getEmail();

    /**
     * Gets the user's phone number
     * @return	 the user's phone number
     */
    public String[] getTelephone();
    /**
     * Gets the user's cell phone number
     * @return	 the user's cell phone number
     */
    public String[] getMobile();
    /**
     * Gets the user's fax number
     * @return	 the user's fax number
     */
    public String[] getFax();

    /**
     * Gets the user's postion (job title)
     * @return	 the user's postion (job title)
     */

    public String getPosition();

    /**
     * Gets the user's department
     * @return	 the user's department
     */
    public String getDepartment();

    /*** ADDRESS  ***/
    /**
     * Gets the user's street address
     * @return	 the user's street address
     */
    public String getStreetAddress();
    /**
     * Gets the user's city
     * @return	 the user's city
     */
    public String getCity();
    /**
     * Gets the user's zip code
     * @return	 the user's zip code
     */
    public String getZip();

    /**
     * Gets the user's country
     * @return	 the user's country
     */
    public String getCountry();
    /**
     * Gets the user's state
     * @return	 the user's state
     */
    public String getState();

    /**
     * Gets the supported namespaces for user data
     * @return	 array of supported namespaces or <code>null</code>
     * if no namespace exists
     * @see		#getKeys(String namespace)
     * @deprecated use 
     * <code>com.sap.security.api.IPrincipal.getAttributeNamespaces()</code> 
     * instead
     */
    public String[] getNamespaces();

    /**
     * Gets the default namespace which is used if attributes which are not
     * qualified with a namespace
     * @return	  String
     * null       if no default namespace exists
     * @deprecated use 
     * <code>com.sap.security.api.IPrincipal.DEFAULT_NAMESPACE</code> 
     * instead
     *  
     */
    public String getDefaultNamespace();

    /**
     * Gets the supported attributekeys for user data
     * @return	 array of supported datakeys or <code>null</code>
     * if no keys exist or if there are no attributes for this namespace
     * @see		#getValuesForKey(String namespace, String datakey)
     * 
     * @deprecated use 
     * <code>com.sap.security.api.IPrincipal.getAttributeNames (String namespace)</code>
     * instead 
     */
    public String[] getKeys(String namespace);

    /**
     * Generic get method to read data
     * @param	namespace	String describing the namespace
     * @param	datakey		String describing the data
     * @return	the respective user data or <code>null</code> if this
     * namespace or key within this namespace does not exist
     * 
     * @deprecated use 
     *  <code>com.sap.security.api.IPrincipal.getAttribute (String namespace, String name)</code> 
     * instead  
     * 
     */
    public String[] getValuesForKey(String namespace, String datakey);


    /** 
     * 
	 * This interface has been replaced by 
	 * interfaces <code>com.sap.security.api.umap.IUserMapping</code> and
	 * <code>com.sap.security.api.umap.IUserMappingData</code> which contains
	 * <code>enrich</code> methods and additional functionality.
	 * These interfaces are part of the User Management Engine(UME) APIs.</I>
	 * The interfaces  
	 * can be accessed via 
	 * <br><code>com.sap.security.api.UMFactory.getUserMapping()</code>
	 * and
	 * <br><code>com.sap.security.api.UMFactory.getUserMapping().getUserMappingData(ISystemLandscapeObject system, IPrincipal pri)</code>
	 * In order to get a 
	 * <br><code>com.sap.security.api.umap.system.ISystemLandscapeObject</code>
	 * use <code>com.sapportals.portal.prt.service.usermapping.IUserMappingService</code>
	 * from EP6 portal. 
	 * 
     */
    public ILogonDataBroker getMappingInfo ();

    /**
     * Gets the user's Locale; this determines e.g. the language in which text
     * is displayed to the user's and the style that numbers are formated.
     *
     * If attribute locale is not mapped as an attribute in configuration_ldap.xml
     * file the locale attribute is fetched and stored
     * {@link IModifyUser#setLocale(java.util.Locale locale)}.<br>
     * in the portal LDAP.
     *
     * Applications needing to get the country where the user resides must call
     * getCountry() instead of using the Locale's country.
     * @return	Locale locale
     *
     */
    public Locale getLocale();

    /**
     * Gets the user's DateFormat.
     * This is calculated based on language and country.
     * @return	 the user's DateFormat
     */
    public DateFormat getDateFormat();

    /**
     * Gets the user's time zone
     * @return	 the user's time zone (as TimeZone object)
     */
    public TimeZone getTimeZoneObject();

    /** Tells whether this instance of IUser has been created after
     *  a successful authentication of the corresponding user.
     *  @return <code>true</code> if user has authenticated, 
     *  <code>false</code> if not.
     * 
     *  @deprecated use interface 
     * 	<br><code>com.sap.security.api.logon.ILogonAuthentication.isAuthenticated(com.sap.security.api.IUser)</code>
     *  instead which can be accessed via 
     *  <code>com.sap.security.api.UMFactory.getLogonAuthenticator().isAuthenticated(IUser)</code>
     *   
     */
    public boolean isAuthenticated ();

    /** Tells whether this instance of IUser is a user
     *  that belongs to the default admin role.
     *  @return true if the user is admin, false if not
     * 
     *  @deprecated there is no equivalent method provided in UME API because of 
     *  the delegated admin concept: there is not only one administration role. 
     *  Instead there are several administration roles:
     * 	<br><code>pcd:portal_content/administrator/super_admin/super_admin_role</code>
     *  <br><code>pcd:portal_content/administrator/content_admin/content_admin_role</code>
     *  <br><code>pcd:portal_content/administrator/system_admin/system_admin_role</code>
     *  <br><code>pcd:portal_content/administrator/user_admin/user_admin_role</code>
     * 	<br><p>The current EP5 implementation is checking the UME property file for 
     * 	property named ume.portal_admin.role. If this property does not exist the
     *  above mentioned four roles which are delivered by SAP are checked if the 
     *  current IUser is assigned to one of these roles (either directly or indirectly 
     * 	via Groups).
     *  <p>If the user is assigned to one of these roles <code>true</code> is returned, 
     *  <code>false</code> otherwise.
     * 
     */
    public boolean isAdmin ();

    /** Tells whether this instance of IUser is a user
     *  that is stored under the external Relative DN under the people root
     *  This means the user is an external user that was created using self registration
     *  and the API method IUserFactory.createUser()
     *
     *  @deprecated there is no equivalent method provided in UME API because of
     *  user objects may be stored in different data stores: LDAP, SAP R/3 or Database.
     *  The semantic in EP5 was based on the physical location of the user
     *  object: in case the user object was stored in a special LDAP branch 
     *  which was based on the former EP5 usermanagement.properties entry:
     * <p>
     * <br># relative DN under the people root where new entries are stored
     * <br>Netscape.user.relDN = ou=ExternalPeople
     * <br>MS-ADS.user.relDN   = cn=externalusers
     * <br>Novell.user.relDN   = ou=ExternalPeople
     * 
     *  In case the user object was located in the above configured LDAP branch
     *  this method returned <code>true</code> and <code>false</code> otherwise.
     *  
     *  The current EP5 implementation is based on following behaviour:
     *  <p>@return <code>true</code> if the user object has a persistent attribute named 
     *  USER_ISEXTERNAL_ATTRIBUTE in namespace 
     * 	<br><code>com.sap.security.api.IPrincipal.DEFAULT_NAMESPACE</code>
     *  <br>with value <code>true</code>
     */
    public boolean isExternal ();

    /**
     *  Get transient attribute - these attribute are not saved permanently but only
     *  for the lifetime of the corresponding user object
     *  @param key the key for this attribute
     *  @return the object mapped to this key or null if no attribute is bound to this key
     * 
     */
     public Object getTransientAttribute(String key);

    /**
     *  Set transient attribute - these attribute are not saved permanently but only
     *  for the lifetime of the corresponding user object
     *  @param key the key for this attribute (must not be null)
     *  @param value the transient attribute (must not be null)
     */
     public void setTransientAttribute(String key, Object value);

    /**
     *  Remove transient attribute
     *  @param key the key for this attribute
     */
     public void removeTransientAttribute(String key);

    /**
     *  Get the names of all transient attributes
     *  @return an enumeration of all transient attribute names
     */
     public java.util.Enumeration getTransientAttributeNames();

    /**
     * Gets the name of the company this user belongs to.
     * @return name or null if this user does not belong to any company
     */
     public String getCompanyName();

    /**
     * Gets the user's post office box
     * @return	name of the user's post office box or null if no value exists
     */
     public String getPobox();

    /**
     * Checks if the user belongs to @param roleId
     * returns true if user is directly or indirectly (via Group membership)
     * assigned to this role
     */
     public boolean isInRole(String roleID);

    /**
     * Gets the user's accessibilityLevel
     * used for Screen Reader Support
     * @return	integer as accessibilityLevel
     * if no value is set in datastore
     * the default return value is
     * DEFAULT_ACCESSIBILITY_LEVEL
     */
     public int getAccessibilityLevel();

    /**
     * Gets the user object of the new user management interface UME
     */
     public com.sap.security.api.IUser getUMEUser();
}
