package com.sapportals.portal.security.usermanagement;

/**
 * Title:        Security
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      SAP AG
 * @author Alexander Primbs
 * @version 1.0
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 * Interface IUMPrincipal describes objects which either have IUser, IGroup or
 * IRole information in common.
 *
  <table border="1"  cols=4 width="800" cellspacing="1">
    <tr>
      <td width="17%"><b>Method</b></td>
      <td><b>IUser</b></td>
      <td><b>IGroup</b></td>
      <td><b>IRole</b></td>
    </tr>
    <tr>
      <td width="17%">getId()</td>
      <td colspan=4> returns the unique Id of a principal. If an implementation of a Principal
      is stored in LDAP, this interface can return a distinguished name. This is
      currently the case for groups. This method is therefore not suitable to be used
      for a GUI application. Use getDisplayId() instead which returns a human readable
      Id.
      </td>
    </tr>
    <tr>
      <td width="17%">getDisplayName()</td>
      <td>if DISPLAYNAME is part of mapping (defined in repository_configuration.xml) for IUser,
       displayName is used. Else getDisplayName() concatenates "LASTNAME, FIRSTNAME".
       This is done only if lastname and firstname are not null. If either LASTNAME or
       FIRSTNAME are null the return value is null.</td>
      <td>if DISPLAYNAME is part of mapping (defined in repository_configuration.xml) for IGroup,
       displayName is used. Otherwise getDisplayName() returns the same value as method getDisplayId().
      </td>
      <td>if DISPLAYNAME is part of mapping (defined in repository_configuration.xml) for IRole,
       displayName is used. Otherwise getDisplayName() returns the same value as method getDisplayId().
      </td>
    </tr>
    <tr>
      <td width="17%">getDisplayId()</td>
      <td colspan=4> returns the unique Id of a principal in a human readable form.
       For example method getId() would return the distinguished
       Name (DN) from LDAP, that is dn is CN=Walldorf,CN=Users,DC=sap,DC=corp.
       However getDisplayId() applied for an IGroup would return the nice name:
       "Walldorf".
      </td>
    </tr>
    <tr>
      <td width="17%">getDescription()</td>
      <td colspan=4 >if DESCRIPTION is part of mapping (defined in repository_configuration.xml) for IUser,
      IGroup or IRole DESCRIPTION is used. Else getDescription() returns null.
      </td>
    </tr>

  </table>
 *
 *
 */
public interface IUMPrincipal
{
        /**
         * Constants used only for package com.sap.wp.security
         */
        static final String DEFAULT_ROLE = "portal_user";
        static final String DEFAULT_ROLE_DISPLAYNAME = "Portal User";

        /**
         * Constants used for attribute mapping. These constants can be used
         * for users, roles and groups
         */
        public static final String DESCRIPTION  = "description";
        public static final String DISPLAYNAME  = "displayname";
        public static final String USERMAPPING  = "usermapping";
        public static final String DISPLAYID    = "displayid";

        /**
         * Constants used for getType() method
         * for users, roles and groups
         */
        public static final int IUSER  = 0;
        public static final int IGROUP = 1;
        public static final int IROLE  = 2;
		public static final int IUMEPRINCIPAL  = 3;
	
    /**
     * Gets the name of the defaultRole
         * The User management always adds "portal_user" to the assigned roles.
     * This interface will return the name "portal_user" for example
     * @return	String the name of the defaultRole which is assigned to
         *              everybody: for example "portal_user"
     */
        public String getDefaultRole();

    /**
     * Gets the list of roles or null if user is not assigned to a role
     *
     * @return	 array of role names or <code>null</code> if no role is assigned
     * @see		#getRoleAttributes(String userRoleName)
         *
     * @return	String[] list of roles
     */
    public String[] getRoles();


    /**
     * Gets the list of roles or null if user is not assigned to a role
     *
     * @return	 array of role names or <code>null</code> if no role is assigned
     * @see		#getRoleAttributes(String userRoleName)
         *
     * @return	String[] list of roles
     */
    public String[] getDirectRoles();


    /**
     * Gets the supported attributekeys for the roles this user belongs to
     * @return	 array of supported attributes or <code>null</code>
         * if no keys exist or if there are no attributes for this userRoleName
     * @see		#getValuesForRoleAttribute(String userRoleName, String datakey)
     */
    public String[] getRoleAttributes(String userRoleName);

    /**
     * Generic get method to read data
     * @param	userRoleName	String describing the user's role name
     * @param	datakey		String describing the data
     * @return	the respective user data or <code>null</code> if this
         * userRoleName or key within this userRoleName does not exist
     */
    public String[] getValuesForRoleAttribute(String userRoleName, String attributeName);

    /**
     * Gets the list of groups
     *
     * @return	Array of string: list of groups or null if the principal is not assigned
         * @deprecated
         * to a group
     */
    public String[] getGroups();

    /**
     * Generic get method to read data
     * @param	datakey		String describing the data
     * @return	the respective user data or <code>null</code> if this
         * key does not exist
     */
    public String[] getValuesForKey(String datakey)
          throws UserManagementException;

    /**
     * Gets the supported attributekeys for user data
     * @return	 array of supported datakeys or <code>null</code>
         * if no keys exist
     * @see		#getValuesForKey(String datakey)
     */
    public String[] getKeys();

    /**
     * Refresh Object
     * Reads all attributes of this object again from data store
     *
     * @throws exception if object could not be refreshed
     */
    public void refresh()
          throws UserManagementException;

    /**
     * Checks wheter this IUser object belongs to Group gid
     * @return	 true if user is in Group
         * false otherwise
     * @see		#getGroups()
     */
        public boolean isInGroup(String id);

    /**
     * Checks wheter this IUMPrincipal object implements interface IGroup
     * @return	 true if IUMPrincipal is a Group
         * false otherwise
         * @deprecated. As of Build 4, replaced by IUMPrincipal.getType()
         * @see        #getType()
     */
        public boolean isGroup();

    /**
     * Retrieves the type of object which implements the interface IUMPrincipal.
     * @return	 int constant defined in IUMPrincipal, e.g. IUMPrincipal.IUSER
     */
        public int getType();

        /**
         * @return unique Id of IUMPrincipal
         */
        public String getId();

        /**
         * To compare the two instances of the implementation. Will return true
         * if both the instances are of the same object type and have the same id
         */
        public boolean equals(IUMPrincipal principal);

    /**
     * Gets the list of all parent groups including parents, grandparents, ...
     *
     * @return	Array of string: list of parent groups or null if the principal is not assigned
         * to a group
     */
    public String[] getAllParentGroups();
    /**
     * Gets the list of all child groups including children, grandchildren, ...
     *
     * @return	Array of string: list of child groups or null if the principal is not assigned
         * to a group
     */
    public String[] getDirectParentGroups();

        /**
         * Get the user mapping data stored for this principal<br>
         * This method only retrieves the raw data from the data store. Required parameters
         * are not checked and passwords are not decrypted. For enrichment of connections to backend
         * systems with mapped logon data, use the methods of {@ILogonDataBroker}.
         *
         * @param application the logical name of the application for which the user mapping
         *  data will be retrieved
         * @return Hashmap containing the raw user mapping parameters or <code>null</code> if no
         *  mapping data has been saved
         */
        public java.util.HashMap getRawUserMappingData (String application);

    /**
     * Returns the description of this principal.
     *
     * @return String: the description of this principal
         *         null  : if no description exists
     */
    public String getDescription();

    /**
     * Returns the displayName of this principal.
     *
     * @return String: the displayName of this principal
         *         null  : if no displayName exists
     */
    public String getDisplayName();

    /**
     * Returns a human readable id of this principal.
     *
     * @return String: the displayName of this principal
         *         null  : if no displayName exists
     */
    public String getDisplayId();


        /**
         * To compare the two instances of the implementation. Will return true
         * if both the instances are of the same object type and have the same id
         */
        public boolean equals(Object obj);

    /**
     * Returns uniqueId of corresponding UME object
     *
     * @return String: uniqueId of the UME principal
     *         null  : if no UME counterpart object exists
     */
    public String getUMEId();        

}