package com.sapportals.portal.security.usermanagement;

import com.sapportals.portal.security.usermanagement.IPortalLogin;
import com.sapportals.portal.security.usermanagement.IUserFactory;
import com.sapportals.portal.security.usermanagement.IGroupFactory;
import com.sapportals.portal.security.usermanagement.IRepositories;

/**
 * This class provides functionality to access a user, group and role factory and
 * also allows to access the portal login handler, a user management event handler
 * and information about the current configuration.
 *
 * Copyright (c) SAP Portals Europe GmbH 2001
 * @author Alexander Primbs
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 */

public interface IUMFactory
{

   /**
     * Obtain the singleton object that creates and oversees IUMFactory
     * implementations.
     *
     * @return the single instance of a  IUMFactory

   public IUMFactory getInstance();
   */

    /**
     * Returns implementation of IAuthentication currently being used.
     * This reads AUTHENTICATION server from properties file, loads the
     * class and creates the instance dynamically.
     *
     * @return	 Authentication object */

    public IPortalLogin getAuthenticator();

    /**
     * Returns user management version
     *
     * @return	 user management version
     */
    public String getUMVersion();

    /**
     * Returns implementation of IUserFactory currently being used.
     * @return IUserFactory object
     */
    public IUserFactory getDefaultFactory();

    /**
     * Returns implementation of IGroupFactory currently being used.
     * This reads grouphierarchyclass key from configuration file, loads the
     * class and creates the instance dynamically.
     *
     * @return	 IGroupFactory object
     */
    public IGroupFactory getGroupFactory();

    /**
     * Returns implementation of IUMEventHandler currently being used.
     *
     * @return	 IUMEventHandler object
     */
    public IUMEventHandler getEventHandler();

    /**
     * Returns implementation of IRoleFactory currently being used.
     * @return IRoleFactory object
     */
    public IRoleFactory getRoleFactory();

    /**
     * Returns configuration data of current repositories
     * @return IRepositories
     */
    public IRepositories getRepositories();
    
	/**
	 * Gets the UME principal factory of the UME user management interface 
	 * @return IPrincipalFactory
	 */
	public com.sap.security.api.IPrincipalFactory getUMEPrincipalFactory();
    
}