package com.sapportals.portal.security.usermanagement;

/**
 * This class allows to register for user mangagement events.
 * IUMEventHandler follows the observer pattern. An observer has to register
 * via registerForEvent. An observer can subscribe more than one time to an event
 * by using different namespaces.
 *
 * Copyright (c) SAP Portals Europe GmbH 2001
 * @author Alexander Primbs
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 */

public interface IUMEventHandler
{
  public static final String USER_CREATED   = "didCreateUser";
  public static final String USER_UPDATED   = "didUpdateUser";
  public static final String USER_DELETED   = "didDeleteUser";
  public static final String USER_RENAMED   = "didRenameUser";

  public static final String GROUP_CREATED  = "didCreateGroup";
  public static final String GROUP_UPDATED  = "didUpdateGroup";
  public static final String GROUP_DELETED  = "didDeleteGroup";
  public static final String GROUP_RENAMED  = "didDeleteGroup";

  public static final String ROLE_CREATED  = "didCreateRole";
  public static final String ROLE_UPDATED  = "didUpdateRole";
  public static final String ROLE_DELETED  = "didDeleteRole";
  public static final String ROLE_RENAMED  = "didRenameRole";

  //public static final String USER_LOGOFF   = "didLogoffUser";
  // -----------------------------
  // Register/UnRegister observers ---------------------------------------------
  // -----------------------------
  /**
   * registerForEvent allows to subscribe to a predefined eventName. Currently
   * following events are supported: ROLE_CREATED, ROLE_UPDATED, ROLE_DELETED and
   * ROLE_RENAMED. Registration additionally needs a namespace string which can
   * be defined by the caller. The caller also has to specify a receiver object
   * which implements the IUMObserver interface.
   */
  public void registerForEvent  ( String nameSpace, String eventName, IUMObserver receiver );

  /***
   * unRegisterForEvent unsubscribes a receiver from a previously subscribed event.
   */
  public void unRegisterForEvent( String nameSpace, String eventName, IUMObserver receiver );

  // -----------------------------
  // Raise event  ---------------------------------------------
  // -----------------------------
  // public void raiseEvent( String nameSpace, String eventName);
  //public void raiseEvent( String nameSpace, String eventName, Object eventObject);
}