package com.sapportals.portal.security.usermanagement;

/**
 * Copyright (c) SAP Portals Europe GmbH 2001
 * @author Alexander Primbs
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 * Interface describing user objects that are used to specify query attributes
 * To be able to search for a User Management Principal you have to specify
 * the search attributes in an object ISearchUMPrincipal first.
 *
 * After specifying the search attributes, the principal object is handed to
 * the according PrincipalFactory in order to call method findUsers or
 * findGroups like in the IGroupFactory
 *
 * {@link IGroupFactory#findGroups(ISearchGroup searchdata, int maxcount)}.<br>
 *
*/

public interface ISearchUMPrincipal
{

    public static final int SEARCHMETHOD_AND = 0;
    public static final int SEARCHMETHOD_OR  = 1;
    public static final int SEARCH_RESULT_OK = 0;
    public static final int SEARCH_RESULT_INCOMPLETE = 1;

    /**
     * generic set method to specify the attribute and its value which is used
     * for searching Principals
     */
        public void setValuesForKey(String key, String[] value);

    /**
     * generic get method to receive all keys which can be used for this object
     * to specify a query
     *
     * getSearchKeys() will return attributes like description, name, etc.
     */
        public String[] getSearchKeys();

     /**
     *
     * To be able to get all users/groups which belong to a role, you have to specify
     * the roleId.
     *
     */
        public void setRole(String rid);

     /**
     *
     * To be able to get all users/groups which belong to a group, you have to specify
     * the groupId.
     *
     */
        public void setGroup(String gid);

     /**
     *
     * To be able to get all users/groups which belong to a group, you have to specify
     * the groupId.
     *
     */
        public void setParentGroup(String gid);


     /**
     *
     * To be able to get all users/groups which DIRECTLY belong to a group, you have to specify
     * the groupId.
     *
     */
        public void setDirectParentGroup(String gid);



     /**
     *
     * Clear all attributes which are set in this object. ISearchUMPrincipal
     * is empty afterwards.
     *
     */
        public void clear();

    /**
     * Set search criteria on id, contains * as wildcard
     * @param	searchID search criteria containing wildcards
     */

        public void setId(String id);

        public String getId();
    /**
     * Get direct parent group search criteria
     * @return	returns the search criteria for the direct parent group
     */
        public String getDirectParentGroup();

    /**
     * Get parent group search criteria
     * @return	returns the search criteria for a parent group (can be direct or indirect)
     */
        public String getParentGroup();

    /**
     * Get found principals
     * @return	Array of Strings containing IDs of found users/groups/roles
     */

        public String[] getResultPrincipals();

    /**
     * Get Result attributes for a found principal
     * @param   principal principal to get result attribute
     * @param   key       attribute to get result for
     * @return	Array of Strings containing attribute values for specified attribute
     */
        public String[] getResultValueForKey(String principal, String key);

    /**
     * Get all result attributes for a specified principal
     * @param   principal principal to get result attributes
     * @return	Array of Strings containing all result attributes
     */

        public String[] getResultKeys(String principal);

    /**
     * Set attributes to return with a search
     * @param   returningAttributes Array of Strings containing attribute names to return with the search
     */
        public void setReturningAttributes(String[] returningAttributes);

    /**
     * Get specified attributes to return with a search
     * @return   Array of Strings containing attribute names to return with the search
     */
        public String[] getReturningAttributes();


    /**
     * Set the search method (AND|OR) for search on attributes
     * @param   int SEARCHMETHOD_AND|SEARCHMETHOD_OR
     */
        public void setSearchMethod(int searchMethod);

    /**
     * Get the search result code (SEARCH_OK | SEARCH_RESULT_INCOMPLETE)
     * @return  result code (SEARCH_OK | SEARCH_RESULT_INCOMPLETE)
     */
        public int getSearchResult();


        public void setDirectRole(String direcRole);

        //public void setRole(String role);

}