package com.sapportals.portal.security.usermanagement;

/**
 * The class implementing this interface provides methods to Role objects
 * @deprecated <I>This interface has been
 * replaced by interface <code>com.sap.security.api.IRoleFactory</code> which is 
 * part of the User Management Engine(UME) APIs.</I>
 */

public interface IRoleFactory
{
        public static final int FULL     = 0;
        public static final int MINIMUM  = 1;
        public static final int TRUSTED  = 2;

    /**
     * Creates a new role.
     *
     * @param	String roleId the unique id of the role object, which will be created
         * @param       String description
     * @exception	UserManagementException if role could not be created in
         *              data store
     */
    public IModifyRole createRole(String roleId, String description) throws UserManagementException;

    /**
     * Creates a new role. This interface should be used for mass import of
         * assigned roles. A migrated role already has assigned users and groups.
     *
     * @param	String roleId the unique id of the role object, which will be created
         * @param       String description
         * @param       String[] assignedPrincipals list of users/groups which
         *              are assigned to this role
         *              No consistency check is done when assignedPrincipals
         *              are stored: no check if user or group exists !
     * @exception	UserManagementException if role could not be created in
         *              data store
     */
    public IModifyRole createRole(String roleId, String description, String[] assignedUsers, String[] assignedGroups)
           throws UserManagementException;



    /**
     * Creates a new role.
     *
     * @param	String roleId the unique id of the role object, which will be created
     * @exception	UserManagementException if role could not be created in
         *              data store
     */
    public IModifyRole createRole(String roleId) throws UserManagementException;

    /**
     * Deletes a role
     *
     * @param	String roleId of the role object, which will be deleted
     * @exception	UserManagementException
     */
    public void deleteRole(String roleId) throws UserManagementException;

    /**
     * Rename a role
     *
     * @param	String roleId of the role object, which will be renamed
     * @exception	UserManagementException
     * @deprecated there is no equivalent UME API available for renaming of roles.
     * Use <code>com.sap.security.api.IRoleFactory.newRole()</code> instead and 
     * copy the old role values into the new role. Afterwards use
     * <code>com.sap.security.api.IRoleFactory.delete()</code> in order to delete the
     * old role.
     */
    public void renameRole(String oldRoleId, String newRoleId) throws UserManagementException;

    /**
     * Returns a Role object for an existing Role.
     *
     * @param	rid	Short Role id of the role
     * @return	IRole	a role object implementing IRole
         * <code>null</code> if no role is available
     * @exception		UserManagementException
     */
    public IRole getRole(String rid)
        throws UserManagementException;

        /**
         * Returns a role object for a given role id
         *
         * @param	rid		id of the role
         * @param	mode    following modes are allowed:
         *   FULL   : all the data necessary for this role object is contained in this object. The object
         *            representing the IRole interface contains all information fetched from the persistence
         *            layer
         *   MINIMUM: it is checked that the IRole object exists in the persistence layer and only contains
         *            minimum set of data. If additional data is needed which is transparent to the application
         *            there is a round trip necessary to fetch additional data.
         *   TRUSTED: the role object returned is not guaranteed to exist on the persistence layer
         *            If this option is chosen, it is not checked if the role object exists in the data store.
         *            This means, you will get an IRole object which does not belong to your data store population.
         *            For such an object it only makes sense to call following interfaces of IRole method:
         *            @link IUMPrincipal#equals(IUMPrincipal principal)
         *            @link IUMPrincipal#getType();
         *            All other methods will return a @link UserManagementRuntimeException if this role does
         *            not exist
         *
         *
         * @return	IRole	a role object implementing IRole
         *
         * @exception		UserManagementException
         * @deprecated
         */
        public IRole getRole(String uid, int mode)
                throws UserManagementException;
    /**
     *  Returns a IModifyRole object to be used to modify a role.
     * <p>
     * Call method save of IModifyRole to update the role information.
     *
     *@param  rid	rid of Role that should be modified
     *@return	IModifyRole to modify the role
         *<code>null</code> if role does not exist
     *@exception  UserManagementException
     */
    public IModifyRole getModifyRole(String rid)
        throws UserManagementException;

    /**
     *  Returns a IModifyRole object to be used to modify a role.
     * <p>
     * Call method save of IModifyRole to update the role information.
     *
     *@param  IRole role that should be modified
     *@return	IModifyRole to modify the role
         *<code>null</code> if role does not exist
     *@exception  UserManagementException
     */
    public IModifyRole getModifyRole(IRole role)
        throws UserManagementException;

    /**
     *  Returns multiple Role objects for existing rids.
     *
     *@param  ISearchRole object
     *@return String[] array of Role IDs implementing IRole
     *  <code>null</code> if rids are not found
     *@exception  UserManagementException
     */
    public String[] findRoles( ISearchRole searchRole, int maxCount ) throws UserManagementException;


    /**
     *  Returns an ISearchRole object to be used to specify query attributes
     * <p>
         * ISearchRole only contains attributes which will be queried
     *
     * @return     ISearchRole without attributes
         *
     * @exception  UserManagementException
     */
    public ISearchRole getSearchRole() throws UserManagementException;

        public static final String DEFAULT_CONTENT_MANAGER_ROLE = "com.sapportals.portal.content_managers";
        public static final String DEFAULT_KM_ROLE = "com.sapportals.portal.km_admin";

    /**
     * Gets the user object of the new user management interface UME
     */
     public com.sap.security.api.IRole getUMERole(com.sapportals.portal.security.usermanagement.IRole ep5Role)
            throws com.sap.security.api.NoSuchRoleException;
    /**
     * Gets the EP5.0 user object of the new user management interface UME
     */
     public com.sapportals.portal.security.usermanagement.IRole getEP5Role(com.sap.security.api.IRole umeRole)
        throws UserManagementException;
}