package com.sapportals.portal.security.usermanagement;

/**
 * This class provides functionality to read role information.
 *
 * @author  Alexander Primbs
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 *
 */


public interface IRole extends IUMPrincipal
{

    public final static String ADMIN = "portal_admin";


    /**
     * Returns all Users belonging to this role. This method returns the directly
     * assigned users to this role as well as the users who are assigned to groups
     * which belong to this role.
     *
     * @return Array of IUser.
     */
    public String[] getAllUsers();

    /**
     * Returns all Users which are assigned directly to this role.
     *
     * @return Array of IUser.
     */
    public String[] getDirectUsers();

    /**
     * Returns all Groups belonging to this role. This method returns the directly
     * assigned groups to this role as well as the childgroups.
     *
     * @return Array of Strings containing the groupIds.
     */
    public String[] getAllGroups();

    /**
     * Returns all Groups which are assigned directly to this role.
     *
     * @return Array of Strings containing the groupIds.
     */
    public String[] getDirectGroups();

    public boolean containsUser(String userID);
    public boolean containsGroup(String groupID);

    /**
     * Gets the role object of the new user management interface UME
     */
     public com.sap.security.api.IRole getUMERole();
}