package com.sapportals.portal.security.usermanagement;

import java.util.Map;

/**
 * This class provides functionality to read repository information of a given
 * repository.
 *
 * Copyright (c) SAP Portals Europe GmbH 2001
 * @author Alexander Primbs
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 */

public interface IRepository
{
  public static final int USERSECTION  = 0;
  public static final int GROUPSECTION = 1;
  public static final int ROLESECTION  = 2;

  public static final String TypeString [] =
  {
      "USER_SECTION",     // user section
      "GROUP_SECTION",    // group section
      "ROLE_SECTION"      // role section
  };

  /***
   * returns the logical repository name
   *
   * @return String of repository name
   */
   public String getName();

  /***
   * returns PRINCIPAL information
   *
   * @return String of user who accesses the datasource
   */
   public String getLogin(int type);


  /***
   * returns root information
   *
   * @return String of root access of data
   */
   public String getRoot(int type);

  /***
   * returns server information
   *
   * @return String of server
   */
   public String getServer(int type);

  /***
   * returns port information
   *
   * @return String of server port
   */
   public String getPort(int type);

  /***
   * returns server type information
   * this is currently used for LDAP vendors
   * (MS-ADS|Novell|Netscape) as in registry
   *
   * @return String of server type
   */
   public String getServerType(int type);

  /***
   * returns a hashMap with name/value pairs of attributes for this datasource,
   * that is logical attribute name and physical attribute name:
   *  name:   email (logical name)
   *  value:  Email (physical name)
   *
   * @return hashMap
   */
   public Map getAttributeMap(int type);


  /***
   * returns a Flag if SSL is set
   * true = SSL-connection
   * false = non-SSL-connection
   *
   * @return String of class name
   */
   public boolean getSSL(int type);

  /***
   * returns a Flag if repository
   * is initialized and running
   * true = initialized
   * false = initialization failed
   *
   * @return boolean initialization status
   */
   public boolean isInitialized(int type);

  /***
   * returns the last error of initialization
   * @return String last error
   */
   public String getError(int type);

  /***
   * returns true if the repository can only read user data section
   * @return boolean: false if repository content can be changed
   */
   public boolean isUserSectionReadOnly();

  /***
   * returns true if the repository can only read group data section
   * @return boolean: false if repository content can be changed
   */
   public boolean isGroupSectionReadOnly();

  /***
   * returns true if the repository can only read role data section
   * @return boolean: false if repository content can be changed
   */
   public boolean isRoleSectionReadOnly();
}