package com.sapportals.portal.security.usermanagement;

import java.util.*;

/**
 * This class provides functionality to read information of the current
 * configuration.
 *
 * Copyright (c) SAP Portals Europe GmbH 2001
 * @author Alexander Primbs
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 */

public interface IRepositories
{

  /**
   * return the names of the current contained repositories
   */
   public String[] getRepositoryNames();

  /**
   * return an IRepository object from a list of repositories by name
   */
   public IRepository getRepository(String repositoryName);

   /**
    * Returns the currently used UM Properties (read from Parameters)
    */
   public Properties getUMProperties();

   /**
    * returns the location of UMProperties file
    */
   public String getUMPropertiesFileLocation();

}


